@echo off

rem --- edit these variable params: 

set BUILDPATH=.\build
set BINPATH=C:\Users\jafma\Downloads\arduino-1.0.5-r2\hardware\tools\avr\bin

rem --- Do not edit the following:

if -%1-==-- echo Usage: linkwin "executable file" "object file 1" "object file 2" ... & exit /b
if -%2-==-- echo Usage: linkwin "executable file" "object file 1" "object file 2" ... & exit /b

setlocal EnableDelayedExpansion
REM Prevent affecting possible callers of the batch
REM Without delayed expansion, !arg%argno%! used below won't work.
set argcount=0
set objects=
:argactionstart
if -%1-==-- goto argactionend
set /a argcount+=1

if %argcount% equ 1 set executable=%~n1%
if %argcount% neq 1 set objects=%objects% %BUILDPATH%\%~n1%.o

shift
goto argactionstart

:argactionend

set CPU=atmega328p
set CLOCK=16000000L
set ARDUINOCOMPILEOPTS=-DUSB_VID=null -DUSB_PID=null -DARDUINO=105 
set COMPILEOPTS=-Wall -fno-exceptions -ffunction-sections -fdata-sections
set OPTIMIOPTS=-O0

@echo on 

rem --- link - generate elf

"%BINPATH%\avr-gcc" %OPTIMOPTS% -Wl,--gc-sections -mmcu=%CPU% -o "%BUILDPATH%\%executable%.elf" %objects% -lm

"%BINPATH%\avr-size" "%BUILDPATH%\%executable%.elf"

echo (text is code, bss is data, dec is total)

rem --- link - generate hex

"%BINPATH%\avr-objcopy" -O ihex -R .eeprom "%BUILDPATH%\%executable%.elf" "%BUILDPATH%\%executable%.hex" 
