@echo off

rem --- edit these variable params:

set BUILDPATH=.\build
set BINPATH=C:\Users\jafma\Downloads\arduino-1.0.5-r2\hardware\tools\avr\bin
set OPTIMIOPTS=-O0

rem --- Do not edit the following:

set COMPILEXTRAOPTS=%2
set PROGRAM=%1
set FILENAME=%~n1
IF [%FILENAME%] == [] (
	echo You must provide a file+path for the source, with extension.
	exit /b
)

set CPU=atmega328p
set CLOCK=16000000L
set ARDUINOCOMPILEOPTS=-DUSB_VID=null -DUSB_PID=null -DARDUINO=105
set COMPILEOPTS=-Wall -fno-exceptions -ffunction-sections -fdata-sections

@echo on

rem --- compile source

"%BINPATH%\avr-gcc" -g %COMPILEOPTS% %OPTIMIOPTS% %COMPILEXTRAOPTS% -mmcu=%CPU% -DF_CPU=%CLOCK% -MMD %ARDUINOCOMPILEOPTS% -c "%PROGRAM%" -o "%BUILDPATH%\%FILENAME%.o"

rem --- preprocessed code

"%BINPATH%\avr-gcc" -g %COMPILEOPTS% %OPTIMIOPTS% -mmcu=%CPU% -DF_CPU=%CLOCK% -MMD %ARDUINOCOMPILEOPTS% -E "%PROGRAM%" -o "%BUILDPATH%\%FILENAME%.i"

rem --- generate assembly

"%BINPATH%\avr-objdump" -xdrCS "%BUILDPATH%\%FILENAME%.o" > "%BUILDPATH%\%FILENAME%.asm"
