/* Test program for rs-232 in atmega328P */

/* NOTES:

	-The code below only works correctly with ATmega328P @ 16MHz, and sets
	RS232 to asynchronous, 38400 bauds, no parity, 1 stop bit, 8 data bits.

	-Transmissions in either direction consists of textual commands that cannot
	contain 0-ascii bytes because that byte indicates the end of the command,
	and must fit within RS232BUFSIZE (counting the ending 0).

	-In windows, you can use putty, for example, in order to connect to the
	arduino and test this program.
*/


#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include "rs232atmega.h"

#define MYRS232BUFSIZE 32
#define MYRS232ENDCHAR '\r'
#define MYRS232SENDSIZE 128
#define MYRS232BAUDS 38400UL

char rs232inputbuf[MYRS232BUFSIZE];
RS232InputReport rs232report;
char rs232sentcommand[MYRS232SENDSIZE];

int main(void)
{
	cli();
	RS232_Init(rs232inputbuf,MYRS232BUFSIZE,MYRS232ENDCHAR,MYRS232BAUDS);
	sei();
	// endless loop receiving commands and responding with echoes
	// communications initiated by external computer
	snprintf(rs232sentcommand,MYRS232SENDSIZE,
			 "Write any number of lines (max %d chars per line) "
			 "and press enter to see the echo.\r\n",
			 MYRS232SENDSIZE-1);
	RS232_Send(rs232sentcommand,0);
	RS232_Send("After each echo, the led of the Arduino "
			   "will toggle (initially set).\r\n\r\n",0);
	DDRB=(1<<5);
	PORTB |= (1 << 5);
	unsigned char stled=1;
	while (1)
	{
		RS232_Read(&rs232report);
		if (stled) PORTB&=(~(1<<5));
		else PORTB|=(1 << 5);
		stled=!stled;
		unsigned char f=0;
		while ((f<MYRS232BUFSIZE)&&(rs232inputbuf[f]!=MYRS232ENDCHAR)) f++;
		if (f<MYRS232BUFSIZE) rs232inputbuf[f]=0;
		else rs232inputbuf[MYRS232BUFSIZE-1]=0;
		snprintf(rs232sentcommand,MYRS232SENDSIZE,
				 "!(bufov=%d,lasterr=%d,lastinputchr=%d,readlen=%d): [%s]\r\n",
				 rs232report.bufov,
				 rs232report.lasterr,
				 rs232report.lastinputchar,
				 f,
				 rs232inputbuf);
		RS232_Send(rs232sentcommand,0);
	}
	return(0);
}
