#include "mex.h"
#include "windows.h"
#include "P1202.h"
#include "malloc.h"


void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er,f,l,m,n;
 double deldef=0;
 double *po,*po2,*po3,*po4,*posal;

	if (nlhs!=1) 
		mexErrMsgTxt("This function yields one result value!");
	else if ((nrhs<2)||(nrhs>4))
		mexErrMsgTxt("This function needs:\n\tThe DA output channel number (0-1)\n\tThe value to send if only one, any value otherwise (0 to 4095)\n\t[optional] The vector to send if more than one\n\t[optional] Delay between sendings in microseconds (max. 8191)");

	po=mxGetPr(prhs[0]);
	po2=mxGetPr(prhs[1]);
	if (nrhs>2) 
	{
		po3=mxGetPr(prhs[2]);
		m=mxGetM(prhs[2]); 
		n=mxGetN(prhs[2]);
		if ((m!=1)&&(n!=1)) mexErrMsgTxt("PCI1202 needs a vector array to send!");
		if (m==1) l=n;
		else l=m;
	}
	else 
	{
		po3=po2;
		l=1;
	}
	if (nrhs>3) po4=mxGetPr(prhs[3]);
	else po4=&deldef;
	if ((po4[0]<0)||(po4[0]>8191)) mexErrMsgTxt("PCI1202 cannot delay that value!");
	if ((po[0]!=0)&&(po[0]!=1)) mexErrMsgTxt("PCI1202 has only DA channels #0 and #1!");
	
	for (f=0; f<l; f++) if ((po3[f]<0)||(po3[f]>4095)) mexErrMsgTxt("PCI1202 DA channels only can output digital values from 0 to 4095!");

	for (f=0; f<l; f++)
	{
		er=P1202_Da(po[0],po3[f]); // er=P1202_DaF(po[0],po3[f]); // Vicente (revisar)
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at DA sending!");
		if (po4[0]>0)
		{
			er=P1202_DelayUs(po4[0]);
			if (er!=NoError) mexErrMsgTxt("PCI1202 error at delaying!");
		}
	}
	plhs[0]=mxCreateDoubleMatrix(1,1,mxREAL);
	posal=mxGetPr(plhs[0]);
	posal[0]=0;
}


