#include "mex.h"
#include "windows.h"
#include "P1202.h"
#include "malloc.h"

typedef enum {	INPUTCH=0,
				CONFIG,
				CTYPE,
				OUTPUTCH,
				VECTOR } OffsetsParms;

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er,w1,w2,addrt,addrc,addrd,addra,board;
 long f,l,m,n;
 double deldef=0,tant,torg;
 double *pi,*po,*pc,*pt,*pv,*posal;
 float v;
 LARGE_INTEGER tickspersecond,t;
 
	if (nlhs!=1) 
		mexErrMsgTxt("This function yields one result value!");
	else if (nrhs!=5)
		mexErrMsgTxt("This function needs:\n\tAD input channel (0-31)\n\tConfiguration code\n\tType of card (0-1)\n\tDA output channel (0-1)\n\tVector to send [0..4095]\n");

	pi=mxGetPr(prhs[INPUTCH]);
	po=mxGetPr(prhs[OUTPUTCH]);
	pc=mxGetPr(prhs[CONFIG]);
	pt=mxGetPr(prhs[CTYPE]);
	pv=mxGetPr(prhs[VECTOR]);

	if ((*pi<0)||(*pi>31)) mexErrMsgTxt("PCI1202 input channel out of range!");
	if ((*po<0)||(*po>1)) mexErrMsgTxt("PCI1202 output channel out of range!");
	if ((*pc<0)||(*pc>27)||((*pc>11)&&(*pc<16))) mexErrMsgTxt("PCI1202 configuration code out of range!");
	if ((*pt<0)||(*pt>1)) mexErrMsgTxt("PCI1202 card type out of range!");
	
	m=mxGetM(prhs[VECTOR]); 
	n=mxGetN(prhs[VECTOR]);
	if ((m!=1)&&(n!=1)) mexErrMsgTxt("PCI1202 needs a vector array to send!");
	if (m==1) l=n;
	else l=m;
	for (f=0; f<l; f++) if ((pv[f]<0)||(pv[f]>4095)) mexErrMsgTxt("PCI1202 DA channels only can output digital values from 0 to 4095!");

	plhs[0]=mxCreateDoubleMatrix(1,l*2+1,mxREAL);
	posal=mxGetPr(plhs[0]);

	w1=0;
	w2=0;
	er=P1202_SetChannelConfig((WORD)*pi,(WORD)*pc);
	if (er!=NoError) mexErrMsgTxt("PCI1202 error in setting quantification window!");
	board=P1202_WhichBoardActive();
	er=P1202_GetConfigAddressSpace(board,&addrt,&addrc,&addrd,&addra);
	if (er!=NoError) mexErrMsgTxt("PCI1202 error retrieving active board information!");

/*	P1202_SetCounter(addrt,2,0xB0,0); modo 10 11 000 0, cuenta mxima */
	for (f=0; f<l; f++)
	{

		er=P1202_Da(*po,pv[f]);  // er=P1202_DaF(*po,pv[f]); // Vicente (revisar)
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at DA sending!");		
		er=P1202_AdPolling(&v);
		posal[f]=v;
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at reading AD!");

		QueryPerformanceCounter(&t);
		posal[l+f]=(double)t.QuadPart;
/*
		posal[l+f]=P1202_ReadCounter(addrt,2,0x80);
		P1202_SetCounter(addrt,2,0xB0,0); modo 10 11 000 0, cuenta mxima */
	}

	QueryPerformanceFrequency(&tickspersecond);
	for (f=2*l-1; f>l; f--) 
		posal[f]=(posal[f]-posal[f-1])/(double)tickspersecond.QuadPart;
	posal[l]=0.0;
	for (f=l+1; f<2*l; f++)	posal[f]+=posal[f-1];
	posal[2*l]=(double)tickspersecond.QuadPart;

	/* Convierte los tiempos de contador ledos en tiempos reales, asumiendo que el reloj del contador usado
	es de 8MHz (pulsos de 0.125 microsegs) */
/*	for (f=l; f<2*l; f++)
	{
		if (f==l) posal[f]=0;
		else posal[f]=posal[f-1]+(65536-posal[f])*0.125e-6;
	}*/
}

