function a=PCI1202_ReadAD(b,c,d,e,f)

% A=PCI1202_ReadAD(B,C,D,E,F)
%
% Read digital values from an input analogic/digital channel. 
%
% Inputs:
%   B=              input A/D channel number (0 to 31)
%   C=              quantification window (see below)
%   D=              type of board (0->L, 1->H)
%   E [optional]=   number of floating values to acquire
%   F [optional]=   hardware delay between readings or 0 if no delay (in units of microseconds, up to 8191 units)
%
% Outputs:
%   A=  row vector with the floating data (in volts, as indicated by the quantification window)
%
% Quantification Window codes: 
% 
%  Although an analogic input channel always reads a value
%  within [-10..10] volts, for quantifying that value a range of
%  digital values must be mapped into some portion (window) of the
%  [-10..10] range. The window of the [-10..10] range that will
%  correspond to the digital range is set by the quantification window code. 
%
%  NOTE: analog input voltages outside the selected window are truncated to the bound voltages. 
%
%   If PCI1202 board selected type is L, the quantification window codes are:
%       0->     bipolar +/-5v
%       1->     bipolar +/-2.5v
%       2->     bipolar +/-1.25v
%       3->     bipolar +/-0.625v
%       4->     bipolar +/-10v
%       5->     bipolar +/-5v
%       6->     bipolar +/-2.5v
%       7->     bipolar +/-1.25v
%       8->     unipolar 0-10v
%       9->     unipolar 0-5v
%       10->    unipolar 0-2.5v
%       11->    unipolar 0-1.25v
%   If PCI1202 board selected type is H, the window codes are:
%       16->     bipolar +/-5v
%       17->     bipolar +/-0.5v
%       18->     bipolar +/-0.05v
%       19->     bipolar +/-0.005v
%       20->     bipolar +/-10v
%       21->     bipolar +/-1v
%   	  22->     bipolar +/-0.1v
%   	  23->     bipolar +/-0.01v
%   	  24->     unipolar 0-10v
%   	  25->     unipolar 0-1v
%   	  26->     unipolar 0-0.1v
%   	  27->     unipolar 0-0.01v

