#include "mex.h"
#include "windows.h"
#include "P1202.h"
#include "malloc.h"


void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er,f,*scan,aux1,aux2,aux3;
 double nrdef=1,interdef=0;
 double *po,*po2,*po3,*po4,*po5,*posal;

 float v;
 
	if (nlhs!=1) 
		mexErrMsgTxt("This function yields one result value!");
	else if ((nrhs<3)||(nrhs>5))
		mexErrMsgTxt("This function needs: \n\tAD input channel number (0-31)\n\tconfiguration code\n\ttype of card (0-1)\n\t[optional] number of reads\n\t[optional] delay interreads (microseconds, maximum 8191)\n");

	po=mxGetPr(prhs[0]);
	po2=mxGetPr(prhs[1]);
	po3=mxGetPr(prhs[2]);
	po4=&nrdef;
	po5=&interdef;
	if (nrhs>3)
	{
		po4=mxGetPr(prhs[3]);
		if (nrhs>4)
		{
			po5=mxGetPr(prhs[4]);
		}
	}
	if ((po[0]<0)&&(po[0]>31)) mexErrMsgTxt("PCI1202 AD channels range from #0 to #31!");
	if ((po2[0]<0)||(po2[0]>27)||((po2[0]>11)&&(po2[0]<16))) mexErrMsgTxt("PCI1202 configuration code invalid!");
	if ((po3[0]!=0)&&(po3[0]!=1)) mexErrMsgTxt("PCI1202 types of card can be only 0 or 1!");
	if (po4[0]<=0) mexErrMsgTxt("PCI1202 cannot read that number of data!");
	if ((po5[0]<0)||(po5[0]>8191)) mexErrMsgTxt("PCI1202 cannot delay that number!");

	plhs[0]=mxCreateDoubleMatrix(1,po4[0],mxREAL);
	posal=mxGetPr(plhs[0]);

/*	if((po4[0]>1) && (po5[0]==0)) // Lectura a la mxima velocidad del bus
	{
		P1202_ClearScan();
		er=P1202_AddToScan(po[0],po2[0],1,0,0,0);
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at configuring channel scan!");
		scan=malloc(po4[0]*sizeof(WORD));
		er=P1202_SaveScan(po[0],scan);
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at setting the memory buffer for scans!");
		er=P1202_StartScan(80,po4[0],0);
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at starting scan!");
		P1202_WaitMagicScanFinish(&aux1,&aux2,&aux3);
		if (aux1!=0x80) mexErrMsgTxt("PCI1202 error at finishing scan!");
		for (f=0; f<po4[0]; f++) posal[f]=scan[f];
		free(scan);
		P1202_ClearScan();
	}
	else			// Lectura a velocidad controlada
	{
 */
		er=P1202_SetChannelConfig(po[0],po2[0]);
		if (er!=NoError) mexErrMsgTxt("PCI1202 error in setting quantification window!");
		for (f=0; f<po4[0]; f++)
		{

			er=P1202_AdPolling(&v);
			if (er!=NoError) mexErrMsgTxt("PCI1202 error at reading AD!");
			posal[f]=v;
			if (po5[0]>0) 
			{
				er=P1202_DelayUs(po5[0]);
				if (er!=NoError) mexErrMsgTxt("PCI1202 error at delaying!");
			}
		}
//	}
}


