function [ti,ou,er,co]=PCI1202_PID(b,c,d,e,f,g,h,i,j)

% [ti,ou,er,co]=PCI1202_PID(B,C,D,E,F,G,H,I,J)
%
% Implements a PID on a plant which output is connected to an input A/D channel and which input is
% connected to an output D/A channel
%
% Inputs:
%   B=   input A/D channel number for reading plant output (0 to 15)
%   C=   quantification window code (see PCI1202_ReadAD)
%   D=   type of A823 board for reading (0->L, 1->H) -see PCI1202_ReadAD-
%   E=   output D/A channel number for sending control signal (0,1)
%   F=   vector of values that represents the reference signal (in volts)
%   G=   sample period, in units of microseconds (0 for not delaying, maximum 8191)
%   H=   Proportional constant of the controller
%   I=   Integral constant of the controller
%   J=   Derivative constant of the controller
%
%	The PID action will be:  H*error+I*integ(error)+J*deriv(error)
%
% Outputs:
%
%   ti= row vector with the time values taken at each control moment (seconds, real-time)
%   ou= row vector with the plant output taken at each control moment (volts)
%   er= row vector with the difference (reference signal - plant output), in volts
%   co= row vector with the controller output at each control moment (volts)
%