#include "mex.h"
#include "windows.h"
#include "P1202.h"
#include "malloc.h"

typedef enum {	INPUTCH=0,
				CONFIG,
				CTYPE,
				OUTPUTCH,
				VECTOR,
				DELAYS,
				PCT,
				ICT,
				DCT
			 } OffsetsParms;

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er,f,l,m,n,w1,w2,a,board,addrt,addrc,addrd,addra;
 long retar;
 double deldef=0,tant,torg,salida,error,accionp,accioni,acciond,acciondold,erroracc,errorold,accion;
 double tcount,tcountold,tact,told;
 double *pi,*po,*pc,*pt,*pd,*pv,*postime,*posal,*poserr,*posctrl,ppk,pik,pdk;
 float v;

 	if (nlhs!=4) 
		mexErrMsgTxt("This function yields four result values (time samples, system output, error signal, and control signal)!");
	else if (nrhs!=9)
		mexErrMsgTxt("This function needs:\n\tAD input channel (0-15)\n\tConfiguration code\n\tType of card (0-1)\n\tDA output channel (0-1)\n\tVector of reference signal (volts)\n\tSample period in microseconds\n\tP constant\n\tI constant\n\tD constant");

	pi=mxGetPr(prhs[INPUTCH]);
	po=mxGetPr(prhs[OUTPUTCH]);
	pc=mxGetPr(prhs[CONFIG]);
	pt=mxGetPr(prhs[CTYPE]);
	pd=mxGetPr(prhs[DELAYS]);
	pv=mxGetPr(prhs[VECTOR]);
	ppk=*mxGetPr(prhs[PCT]);
	pik=*mxGetPr(prhs[ICT]);
	pdk=*mxGetPr(prhs[DCT]);

	if ((*pi<0)||(*pi>15)) mexErrMsgTxt("PCI1202 input channel out of range!");
	if ((*po<0)||(*po>1)) mexErrMsgTxt("PCI1202 output channel out of range!");
	if ((*pc<0)||(*pc>27)||((*pc>11)&&(*pc<16))) mexErrMsgTxt("PCI1202 configuration code out of range!");
	if ((*pt<0)||(*pt>1)) mexErrMsgTxt("PCI1202 card type out of range!");
	if ((*pd<0)||(*pd>8191)) mexErrMsgTxt("PCI1202 sample period out of range!");
	retar=(WORD)*pd;

	m=mxGetM(prhs[VECTOR]); 
	n=mxGetN(prhs[VECTOR]);
	if ((m!=1)&&(n!=1)) mexErrMsgTxt("((*pc<0)||(*pc>27)||((*pc>11)&&(*pc<16))) needs a vector array as reference!");
	if (m==1) l=n;
	else l=m;

	plhs[0]=mxCreateDoubleMatrix(1,l,mxREAL);
	postime=mxGetPr(plhs[0]);
	plhs[1]=mxCreateDoubleMatrix(1,l,mxREAL);
	posal=mxGetPr(plhs[1]);
	plhs[2]=mxCreateDoubleMatrix(1,l,mxREAL);
	poserr=mxGetPr(plhs[2]);
	plhs[3]=mxCreateDoubleMatrix(1,l,mxREAL);
	posctrl=mxGetPr(plhs[3]);

	erroracc=0.0;
	er=P1202_SetChannelConfig((WORD)*pi,(WORD)*pc);
	if (er!=NoError) mexErrMsgTxt("PCI1202 error in setting quantification window!");
	board=P1202_WhichBoardActive();
	er=P1202_GetConfigAddressSpace(board,&addrt,&addrc,&addrd,&addra);
	if (er!=NoError) mexErrMsgTxt("PCI1202 error retrieving active board information!");
	P1202_SetCounter(addrt,2,0xB6,0);/* modo 10 11 011 0, cuenta mxima */
	for (f=0; f<l; f++)
	{
		// Read timestamp assuming a 8MHz clock
		tcount=P1202_ReadCounter(addrt,2,0x80);
		if (f==0) tact=((65536-tcount)*0.125e-6)/2.0;
		else
		{
			if (tcount>tcountold)	// Se ha desbordado la cuenta
	            tact=told+((tcountold+(65536-tcount))*0.125e-6)/2.0;
			else	// No se desbord la cuenta
	            tact=told+((tcountold-tcount)*0.125e-6)/2.0;
		}

		// Do control
		er=P1202_AdPolling(&v);
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at reading AD!");
		salida=(float)v;
		error=pv[f]-salida;
		erroracc+=error;
		accionp=error*ppk;
		accioni=erroracc*pik;
		if (f==0) acciond=0.0;
		else 
		{
			if (tact==told) acciond=acciondold;
			else acciond=(error-errorold)*pdk/(tact-told);
		}
		accion=accionp+accioni+acciond;
		a=accion;
		if (a<-10) a=-10;
		if (a>10) a=10;
		er = P1202_Da(*po,(WORD)((a+10)/20.0*4095.0)); // er=P1202_DaF(*po,a); // Vicente (revisar)
		if (er!=NoError) mexErrMsgTxt("PCI1202 error at DA sending!");		

		// Update variables
		errorold=error;
		tcountold=tcount;
		told=tact;
		acciondold=acciond;

		// Log data
		postime[f]=tact;
		posal[f]=salida;
		poserr[f]=error;
		posctrl[f]=accion;
		if (retar>0) P1202_DelayUs(retar);
	}
}


