#include "mex.h"
#include "windows.h"
#include "P1202.h"


void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er,tbrds,dllv,drvv,f;
 WORD wAddrTimer,wAddrCtrl,wAddrDio,wAddrAdda;
 double *po,*po2,defverb=1;
 bool verb;

	if (nlhs>2) 
		mexErrMsgTxt("This function yields at most two result values: error code and number of cards present.");
	else if ((nrhs!=0)&&(nrhs!=1))
		mexErrMsgTxt("This function only has an [optional] argument!");

	if (nrhs==1) po=mxGetPr(prhs[0]);
	else po=&defverb;
	verb=(po[0]!=0);

	if (verb)
	{
		mexPrintf("\n          ----------------------------\n");
		mexPrintf(  "           PCI1202 ToolBox for MatLab\n");
		mexPrintf(  "          ----------------------------\n");
		mexPrintf("\n  (c) Dr. Juan Antonio Fernndez Madrigal, 2005\n");
		mexPrintf(  "jafma@ctima.uma.es - www.isa.uma.es/personal/jafma\n");
		mexPrintf("\n      System Engineering and Automation Dpt.\n");
		mexPrintf(  "           University of Mlaga (Spain)\n\n");
		mexPrintf(  "               -------------------\n\n");
	}
	er=P1202_DriverInit(&tbrds);
	if (verb) // print some information about the system
	{
		mexPrintf("Board configuration:\n\n");
		for (f=0; f<tbrds; f++)	
		{
			P1202_GetConfigAddressSpace(f,&wAddrTimer,&wAddrCtrl,&wAddrDio,&wAddrAdda);
			mexPrintf("Card #%02d) Timer: %04xH Control: %04xH DIO: %04xH AD/DA: %04xH\n", 
					f,wAddrTimer,wAddrCtrl,wAddrDio,wAddrAdda);
		}
	}
	if (nlhs>0)
	{
		plhs[0]=mxCreateDoubleMatrix(1,1,mxREAL);
		po=mxGetPr(plhs[0]);
		po[0]=er; // Error code
		if (nlhs>1) 
		{
			plhs[1]=mxCreateDoubleMatrix(1,1,mxREAL);
			po2=mxGetPr(plhs[1]);
			po2[0]=tbrds; // Number of cards
		}
	}
	if (er!=NoError)
	{
		mexPrintf("PCI1202 Driver Error at Initialization (%d).\n",er);
	}
	else
	{
		if (verb) mexPrintf("PCI1202 Driver Initialized Ok! (%d board(s)).\n",tbrds);
		er=P1202_ActiveBoard(0);
		if (nlhs>0) po[0]=er;
		if (er!=NoError)
			mexErrMsgTxt("PCI1202 Board #0 could not be activated.");
		else 
		{
			if (verb) mexPrintf("PCI1202 Board #0 activated ok!\n");
			dllv=P1202_GetDllVersion(); 
			er=P1202_GetDriverVersion(&drvv);
			if (verb) mexPrintf("PCI1202 DLL version %x, Driver version %x.\n",dllv,drvv);
		}
	}

}


