#include "mex.h"
#include "windows.h"
#include "P1202.h"


void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{WORD er;
 double *po;

	if (nlhs!=0) 
		mexErrMsgTxt("This function does not yield any result value!");
	else if (nrhs!=1)
		mexErrMsgTxt("This function needs the number of 1 microsecond units to wait!");

	po=mxGetPr(prhs[0]);
	if (po[0]>8191) mexErrMsgTxt("PCI1202 cannot delay more than 8191 microsecs. units!");

	er=P1202_DelayUs(po[0]);
	if (er!=NoError) mexErrMsgTxt("PCI1202 error at delaying!");
}


