#ifdef __cplusplus
     #define EXPORTS extern "C" __declspec (dllimport)
#else
     #define EXPORTS
#endif

//----------priority setting constant----------------------------------
//
//	    THREAD_PRIORITY_LOWEST
//	    THREAD_PRIORITY_BELOW_NORMAL
//	    THREAD_PRIORITY_NORMAL
//	    THREAD_PRIORITY_ABOVE_NORMAL
//	    THREAD_PRIORITY_HIGHEST
//
//----------priority setting constant----------------------------------

// return code
#define NoError 		0
#define DriverHandleError	1
#define DriverCallError 	2
#define AdControllerError	3
#define M_FunExecError		4
#define ConfigCodeError 	5
#define FrequencyComputeError	6
#define HighAlarm		7
#define LowAlarm		8
#define AdPollingTimeOut	9
#define AlarmTypeError	       10
#define FindBoardError	       11
#define AdChannelError	       12
#define DaChannelError	       13
#define InvalidateDelay        14
#define DelayTimeOut	       15
#define InvalidateData	       16
#define FifoOverflow	       17
#define TimeOut 	       18
#define ExceedBoardNumber      19
#define NotFoundBoard	       20
#define OpenError	       21
#define FindTwoBoardError      22
#define ThreadCreateError      23
#define StopError	       24
#define AllocateMemoryError    25

EXPORTS float  CALLBACK P1202_FloatSub2(float fA, float fB);
EXPORTS short  CALLBACK P1202_ShortSub2(short nA, short nB);
EXPORTS WORD   CALLBACK P1202_GetDllVersion(void);


EXPORTS WORD   CALLBACK P1202_DriverInit(WORD *wTotalBoards);
EXPORTS void   CALLBACK P1202_DriverClose(void);
EXPORTS WORD   CALLBACK P1202_GetDriverVersion(WORD *wVxdVersion);

EXPORTS WORD   CALLBACK P1202_GetConfigAddressSpace(WORD wBoardNo,
	       WORD *wAddrTimer,WORD *wAddrCtrl, WORD *wAddrDio, WORD *wAddrAdda);

EXPORTS WORD   CALLBACK P1202_ActiveBoard( WORD wBoardNo );
EXPORTS WORD   CALLBACK P1202_WhichBoardActive(void);


EXPORTS WORD   CALLBACK P1202_M_FUN_1(WORD wDaFrequency, WORD wDaWave,
	       float fDaAmplitude, WORD wAdClock, WORD wAdNumber,
	       WORD  wAdConfig, float fAdBuf[],
	       float fLowAlarm, float fHighAlarm);

EXPORTS WORD   CALLBACK P1202_M_FUN_2(WORD wDaNumber, WORD wDaWave,
	       WORD  wDaBuf[], WORD wAdClock, WORD wAdNumber,
	       WORD  wAdConfig, WORD wAdBuf[]);

EXPORTS WORD   CALLBACK P1202_M_FUN_3(WORD wDaFrequency, WORD wDaWave,
	       float fDaAmplitude, WORD wAdClock, WORD wAdNumber,
	       WORD wChannelStatus[], WORD wAdConfig[],
	       float fAdBuf[], float fLowAlarm, float fHighAlarm);

EXPORTS WORD   CALLBACK P1202_M_FUN_4(WORD wType, WORD wDaFrequency, WORD wDaWave,
	   float fDaAmplitude, WORD wAdClock, WORD wAdNumber,
	   WORD  wChannelStatus[], WORD wAdConfig[],
	   float fAdBuf[], float fLowAlarm, float fHighAlarm);

EXPORTS WORD  CALLBACK P1202_Di(WORD *wDi);
EXPORTS WORD  CALLBACK P1202_Do(WORD wDo);

EXPORTS WORD  CALLBACK P1202_Da(WORD wDaChannel, WORD wDaVal);
EXPORTS WORD  CALLBACK P1202_SetChannelConfig(WORD wAdChannel,
	       WORD wConfig);

EXPORTS WORD  CALLBACK P1202_AdPolling(float *fAdVal);
EXPORTS WORD  CALLBACK P1202_AdsPolling(float fAdVal[], WORD wNum);
EXPORTS WORD  CALLBACK P1202_AdsPacer(float  fAdVal[],	DWORD dwNum,
							  WORD wSample);

EXPORTS WORD  CALLBACK P1202_ClearScan(void);
EXPORTS WORD  CALLBACK P1202_StartScan(WORD wSampleRateDiv, DWORD dwNum, SHORT nPriority);
EXPORTS void  CALLBACK P1202_ReadScanStatus(WORD *wStatus,
				DWORD *dwLowAlarm, DWORD *dwHighAlarm);
EXPORTS WORD  CALLBACK P1202_AddToScan(WORD wAdChannel, WORD wConfig,
				WORD wAverage, WORD wLowAlarm, WORD wHighAlarm,
							       WORD wAlarmType);
EXPORTS WORD  CALLBACK P1202_SaveScan(WORD wAdChannel, WORD wBuf[]);
EXPORTS void  CALLBACK P1202_WaitMagicScanFinish(WORD *wStatus,
				DWORD *dwLowAlarm, DWORD *dwHighAlarm);
EXPORTS WORD  CALLBACK P1202_StopMagicScan();

EXPORTS WORD  CALLBACK P1202_DelayUs(WORD wDelayUs);

EXPORTS WORD  CALLBACK P1202_Card0_StartScan(WORD wSampleRate, WORD wChannelStatus[],
				      WORD wChannelConfig[],WORD wCount);
EXPORTS WORD  CALLBACK P1202_Card0_ReadStatus(WORD wBuf[], WORD wBuf2[], DWORD *dwP1, DWORD *dwP2,
				      WORD *wStatus);
EXPORTS void  CALLBACK P1202_Card0_Stop(void);

EXPORTS WORD  CALLBACK P1202_Card1_StartScan(WORD wSampleRate, WORD wChannelStatus[],
				      WORD wChannelConfig[],WORD wCount);
EXPORTS WORD  CALLBACK P1202_Card1_ReadStatus(WORD wBuf[], WORD wBuf2[], DWORD *dwP1, DWORD *dwP2,
				      WORD *wStatus);
EXPORTS void  CALLBACK P1202_Card1_Stop(void);

EXPORTS WORD  CALLBACK P1202_FunA_Start(WORD wClock0Div, WORD wChannel0[],
	WORD  wConfig0[], WORD *Buffer0, DWORD dwMaxCount0,
	WORD  wClock1Div, WORD wChannel1[],WORD wConfig1[],
	WORD  *Buffer1, DWORD dwMaxCount1, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_FunA_ReadStatus(void);
EXPORTS WORD  CALLBACK P1202_FunA_Stop(void);
EXPORTS WORD  CALLBACK P1202_FunA_Get(DWORD *P0, DWORD *P1);

EXPORTS WORD  CALLBACK P1202_FunB_Start(WORD wClock0Div, WORD wChannel0[],
	WORD  wConfig0[], WORD *Buffer0, DWORD dwMaxCount0, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_FunB_ReadStatus(void);
EXPORTS WORD  CALLBACK P1202_FunB_Stop(void);
EXPORTS WORD  CALLBACK P1202_FunB_Get(DWORD *P0);

EXPORTS WORD  CALLBACK P1202_MemoryStatus(DWORD *dwTotalPhys, DWORD *dwAvailPhys,
			     DWORD *dwTotalPageFile, DWORD *dwAvailPageFile,
			     DWORD *dwTotalVirtual,  DWORD *dwAvailVirtual);
EXPORTS WORD  CALLBACK P1202_AllocateMemory(HGLOBAL *hMem, WORD *Buffer, DWORD dwSize);
EXPORTS WORD  CALLBACK P1202_FreeMemory(HGLOBAL hMem);
EXPORTS WORD  CALLBACK P1202_StartScanPostTrg(WORD wSampleRateDiv, DWORD dwNum, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_StartScanPreTrg(WORD wSampleRateDiv, DWORD dwNum, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_StartScanMiddleTrg(WORD wSampleRateDiv, DWORD dwN1, DWORD dwN2, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_StartScanPreTrgVerC(WORD wSampleRateDiv, DWORD dwNum, SHORT nPriority);
EXPORTS WORD  CALLBACK P1202_StartScanMiddleTrgVerC(WORD wSampleRateDiv, DWORD dwN1, DWORD dwN2, SHORT nPriority);

//*************************************************
//*************************************************
EXPORTS void  CALLBACK P1202_OutputWord(DWORD wPortAddr, DWORD wOutVal);
EXPORTS void  CALLBACK P1202_OutputByte(DWORD wPortAddr, WORD  bOutVal);
EXPORTS DWORD CALLBACK P1202_InputWord( DWORD wPortAddr);
EXPORTS WORD  CALLBACK P1202_InputByte( DWORD wPortAddr);

//*************************************************
EXPORTS void  CALLBACK P1202_SetCounter(DWORD dwBase, WORD wCounterNo, 
						       WORD bCounterMode, DWORD wCounterValue);
EXPORTS DWORD CALLBACK P1202_ReadCounter(DWORD dwBase, WORD wCounterNo, 
								WORD bCounterMode);
EXPORTS void  CALLBACK P1202_SetCounterA(WORD wCounterNo, 
						       WORD bCounterMode, DWORD wCounterValue);
EXPORTS DWORD CALLBACK P1202_ReadCounterA(WORD wCounterNo, WORD bCounterMode);

