% ------ Basic skeleton to use the Lego Mindstorms simulator

clear;
close all;

addpath('LMMML'); % add simulator library path

s = Lego(); % create the simulated robot
s.changePose([-0.25;-0.7;pi]); % initial, exact pose

% create the environment (walls)
lensideenv=0.92;
s.defineWalls([-lensideenv,0,0,0 ;...
               0,0,0,-lensideenv ; ...
               0,-lensideenv,-lensideenv,-lensideenv ; ...
               -lensideenv,-lensideenv,-lensideenv,0]);
s.changeDrawEnv([-(lensideenv+0.25) -(lensideenv+0.25) 0.25 0.25],1);

% ------- A) write here the physical parameters of the robot

measured_radii = ;
measured_wdist = ;
measured_offsx = ;
measured_offsy = ;
measured_offsphi = ;
measured_x0 = ;
measured_y0 = ;
measured_th0 = ;

% ------- B) write here any constant or variable needed for motion control

T = ; % simulation step time (seconds)

% ------- C) variables needed for logging 

gtposes = []; % to store real poses (ONLY AS A REFERENCE)
ts = []; % to store simulated time
sonars = []; % to store sonar readings
encs = []; % to store encoder readings

withvideo = 0;
if withvideo
    v = VideoWriter('siguelineas.avi','Uncompressed AVI');
    v.FrameRate = 1/T;
    open(v);
end

% ------- D) variables needed for the main loop 

finish = 0; % 1 to finish, 0 to go on
ind = 1; % current iteration
while (~finish)

    % simulate the robot motion during T seconds
    s.simulate(T); 
    if (withvideo)
        figure(s.getFigure());
        fr = getframe(gcf);
        writeVideo(v,fr);
    end
    
    % detect collisions with walls and stop if any
    [c,iw] = s.collision();
    if c
        figure(s.getFigure());
        ws = s.getWalls();
        hold on;
        plot(ws(iw,[1 3]),ws(iw,[2 4]),'r-','LineWidth',2);
        error('Collision with wall #%d',iw);
    end
    
    % ------- E) gather robot data and store it for logging
    
    gtposes = ; 
    ts = ;
    sonars = ;
    encs = ;
    
    % ------- F) draw something more upon the simulation, if you want
    
    h = s.getFigure();
    figure(h);
    hold on;
   
    % ------- G) your control code here
    
    t = s.getSimTime(); % read current time
    
    % ------- H) prepare for next iteration
    
    ind = ind + 1;
    
end

% -------- I) save logs

if (withvideo)
    close(v);
end

h = fopen(sprintf('log.txt','w');
for (f = 1:ind-1)
    fprintf(h,'%f %f %f %f\n',ts(f),encs(f,2),encs(f,1),sonars(f)); % important: first element should be time
end
fclose(h);

% -------- J) final figures

