/*---------------------------------------------------------------
	FILE: CStdOutStream.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CSTDOUTSTREAM_H
#define  CSTDOUTSTREAM_H

#include <MRPT/UTILS/CStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This CStdOutStream derived class allow printing to standard out, normally
	 *    the console text output. Please notice CStdOutStream's are binary streams,
	 *    so "char *" data types only should be used if textual outputs are
	 *    desired.
	 *
	 * \sa CStream
	 */
	class CStdOutStream : public CStream
	{
	protected:
		 /** Method responsible for reading from the stream:
		  *   In this class it has no effect.
		  */
		unsigned int  Read(void *Buffer, unsigned int Count)
		{
			MRPT_UNUSED_PARAM(Buffer); MRPT_UNUSED_PARAM(Count);
			return 0;
		}

		/** Method responsible for writing to the stream.
		 *  Write attempts to write up to Count bytes to Buffer, and returns the number of bytes actually written.
		 */
		unsigned int  Write(const void *Buffer,unsigned int Count)
		{
			char *s = new char[Count+1];
			memcpy(s,Buffer,Count);
			s[Count]='\0';
			::printf(s);
			delete[] s;
                        return Count;
		}

	public:
		 /** Constructor
		  */
		CStdOutStream() { }

		 /** Destructor
		 */
		virtual ~CStdOutStream() { }

		/** It has no efect in this class.
		 */
		unsigned long  Seek(long Offset, CStdOutStream::TSeekOrigin Origin = sFromBeginning)
		{
			MRPT_UNUSED_PARAM(Offset); MRPT_UNUSED_PARAM(Origin);
			return 0;
		}

		/** It has no efect in this class.
		 */
		unsigned long  getTotalBytesCount()  { return 0; }

		/** It has no efect in this class.
		 */
		unsigned long  getPosition() { return 0; }

	}; // End of class def.

	/** A global, static, "CStdOutStream" object that can be used to output text to the console.
	  * \sa CDebugOutputCapable::debugOut
	  */
	extern CStdOutStream	stdOut;

} // End of namespace

#endif
