/*---------------------------------------------------------------
	FILE: CProbabilityParticle.h
	USE: See above

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPROBABILITYPARTICLE_H
#define CPROBABILITYPARTICLE_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CSerializable.h>

namespace UTILS
{
	/** A template class for holding a the data and the weight of a particle.
	*    Particles are composed of two parts:
	 *		- A state vector descritor, which in this case can be any user defined CSerializable class
	 *		- A (logarithmic) weight value.
	 *
	 *  This structure is used within CParticleFilterData, see that class for more information.
	 */
	template <class T>
	struct CProbabilityParticle
	{
	public:
		/** The data associated with this particle.
		 */
		T *d;

		/** The (logarithmic) weight value for this particle.
		 */
		double log_w;

		/** Default constructor:
		 */
		CProbabilityParticle() : d(NULL), log_w(0)
		{
		}
	};

} // End of namespace

#endif
