/*---------------------------------------------------------------
	FILE: CDirectoryExplorer.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CDirectoryExplorer_H
#define  CDirectoryExplorer_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/MRPT_OS.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	#define FILE_ATTRIB_ARCHIVE			0x0020
	#define FILE_ATTRIB_DIRECTORY		0x0010

	/** This class allows the enumeration of the files/directories that exist into a given path.
	  */
	class CDirectoryExplorer
	{
	public:

		/** This represents the information about a file
		  */
		struct TFileInfo
		{
			/** This can be FILE_ATTRIB_ARCHIVE or FILE_ATTRIB_DIRECTORY,...
			  */
			unsigned long		fileAttributes;

			/** The size of the file in bytes.
			  */
			uint64_t	        fileSize;

			/** The name of the file.
			  */
			std::string			fileName;
		};

	protected:
		/** The internal list of found files.
		  */
		std::deque<TFileInfo>	m_foundList;

	public:
		/** Constructor
		  *  According to the following parameters, the object will collect the list of files, which
		  *   can be examined later through other methods in this class.
		  * \param path The path to examine, including wildcards, i.e. "d:\temp\*.txt"
		  * \param mask One or the OR'ed combination of the values "FILE_ATTRIB_ARCHIVE" and "FILE_ATTRIB_DIRECTORY", depending on what file types do you want in the list.
		  */
		CDirectoryExplorer( const std::string &path, unsigned long mask  );

		/** Destructor
		  */
		virtual ~CDirectoryExplorer();

		/** Returns how many entries there are in the list
		  */
		size_t	 size()
		{
			return m_foundList.size();
		}

		/** Returns the i'th element from the list (from 0 to "size()"-1).
		  */
		TFileInfo*  get( size_t i )
		{
			ASSERT_(i<m_foundList.size());
			return &m_foundList[i];
		}

	}; // End of class def.

} // End of namespace /**/

#endif
