/*---------------------------------------------------------------
	FILE: CHarrisFeatureDetector.h
	USE: See doxygen doc.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CHarrisFeatureDetector_H
#define CHarrisFeatureDetector_H

#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMRPTImageFloat.h>
#include <MRPT/MRVL/CGaussianConvolutionKernel.h>
#include <MRPT/MRML/CPointsMap.h>

namespace MRVL
{
	/** This class integrates a Harris feature detector for gray-scale images.
	  * \sa MRVL
	  */
	class CHarrisFeatureDetector
	{
	public:
		/** Options for the KLT algorithm:
		*/
		struct TOptions
		{
			/** Initializer for default values
			*/
			TOptions();

		} m_options;

		/** Computes the Harris features for the image "img" and according to parameters in "m_options", returning the "x" and "y" coordinates of each feature in a "MRML::CPointsMap" class.
		  */
		void  extractFeatures(
			const CMRPTImageFloat	&in_img,
			MRML::CPointsMap				&out_points
			);

	};	// End of class "CHarrisFeatureDetector"

} // End of namespace


#endif
