/*---------------------------------------------------------------
	FILE: CPoint.h
	USE: See above.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPOINT_H
#define CPOINT_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/MRML/CPoseOrPoint.h>

namespace MRML
{

	/** A virtual base class to represent a point in 2D or 3D.
	 *
	 * \sa CPoseOrPoint,CPose, CPoint
	 */
	class CPoint : public CPoseOrPoint
	{
		// This must be added to any CSerializable derived class:
		DEFINE_VIRTUAL_SERIALIZABLE( CPoint )

	public:
		 /** Scalar sum of components: This is diferent from poses
		  *    composition, which is implemented as "+" operators in "CPose" derived classes.
		  */
		 void AddComponents(CPoseOrPoint &p);

		 /** Scalar multiplication.
		  */
		 void operator *=(float s);

	}; // End of class def.

} // End of namespace

#endif
