/*---------------------------------------------------------------
	FILE: CObservationImage.h
	USE: See doc above

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CObservationImage_H
#define CObservationImage_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMatrix.h>
#include <MRPT/MRML/CObservation.h>
#include <MRPT/MRML/CPose3D.h>
#include <MRPT/MRML/CPose2D.h>

namespace MRML
{

	/** Declares a class derived from "CObservation" that encapsules an image from a camera, whose relative pose to robot is also stored.
	     The next figure illustrate the coordinates reference systems involved in this class:<br>
		 <center>
		 <img src="CObservationImage_figRefSystem.png">
		 </center>
	 *
	 * \sa CObservation
	 */
	class CObservationImage : public CObservation
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CObservationImage )

	 public:
		/** Constructor.
		 * \param iplImage An OpenCV "IplImage*" object with the image to be loaded in the member "image", or NULL (default) for an empty image.
		 *
		 */
		CObservationImage( void *iplImage = NULL );

		 /** The data members
		  */
		CPose3D			cameraPose;
		CMatrix			intrinsicParams;
		CMatrix			distorsionParams;	// 4 elements (TODO:...)
		CMRPTImage		image;

		/** The focal length of the camera, in meters (can be used among 'intrinsicParams' to determine the pixel size).
		  * (Added in version 2 of object's streaming)
		  */
		double			focalLength_meters;

		/** Computes the rectified image, using the embeded distortion parameters.
		  */
		void  getRectifiedImage( CMRPTImage &out_img );

		 /** Implements the virtual method in charge of finding the likelihood between this
		  *   and another observation, probably only of the same derived class. The operator
		  *   may be asymmetric.
		  *
		  * \param anotherObs The other observation to compute likelihood with.
		  * \param anotherObsPose If known, the belief about the robot pose when the other observation was taken can be supplied here, or NULL if it is unknown.
		  *
		  * \return Returns a likelihood measurement, in the range [0,1].
		  *	\exception std::exception On any error, as another observation being of an invalid class.
		  */
		 float  likelihoodWith( CObservation *anotherObs, CPosePDF *anotherObsPose = NULL );


	}; // End of class def.

} // End of namespace

#endif
