/*---------------------------------------------------------------
	FILE: CBoardIMU.h

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/

#ifndef CBoardIMU_H
#define CBoardIMU_H

#include <MRPT/HWDRIVERS/CInterfaceFTDIMessages.h>


namespace HWDRIVERS
{

	/** A class for interfacing an Inertial Measuring Unit (IMU) via a FTDI USB link.
	  *  Implemented for the board v2.0 designed by 2007 @ ISA (University of Malaga).
 	  */
	class CBoardIMU : public HWDRIVERS::CInterfaceFTDIMessages
	{
	protected:
		/** A copy of the device serial number (to open the USB FTDI chip)
		  */
		std::string		m_usbSerialNumber;

		/** Tries to connect to the USB device (if disconnected).
		  * \return True on connection OK, false on error.
		  */
		bool	checkConnectionAndConnect();

	public:
		/** Constructor
		  * \param serialNumberUSBdevice The serial number (text) of the device to open.
		  *  The constructor will try to open the device. You can check if it failed calling "isOpen()".
		  */
		CBoardIMU( const std::string & serialNumberUSBdevice );

		/** Destructor
		  */
		virtual ~CBoardIMU();

		/** Query the firmware version on the device (can be used to test communications).
		  * \return true on success, false on communications errors or device not found.
		  */
		bool	queryFirmwareVersion( std::string &out_firmwareVersion );

		/** Query the current readings from the 6 accelerometers (dual-axis chips, each in one axis)
		  * outReadings[0]-[1]: X-Y axis of chip #1
		  * outReadings[2]-[3]: X-Y axis of chip #2
		  * outReadings[4]-[5]: X-Y axis of chip #3
		  * \return true on success, false on communications errors or device not found.
		  */
		bool	queryAccelerometerReadings( vector_uint	&outReadings );


	}; // end of class

} // end of namespace


#endif


