/*---------------------------------------------------------------
	FILE: ZipCompression.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  ZipCompression_H
#define  ZipCompression_H

#include <MRPT/UTILS/utils_defs.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	class CStream;

	/** This class groups static methods allowing easy ZIP compression/decompression.
	 */
	namespace ZipCompression
	{
		/** Compress an array of bytes into another one.
		  */
		void  compress(
			void						*inData,
			size_t						inDataSize,
			std::vector<unsigned char>	&outData);

		/** Compress an array of bytes into another one.
		  */
		void  compress(
			const std::vector<unsigned char>	&inData,
			std::vector<unsigned char>			&outData);

		/** Compress an array of bytes and write the result into a stream.
		  */
		void  compress(
			void						*inData,
			size_t						inDataSize,
			CStream						&out);

		/** Compress an array of bytes and write the result into a stream.
		  */
		void  compress(
			const std::vector<unsigned char>	&inData,
			CStream								&out);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			void						*inData,
			size_t						inDataSize,
			std::vector<unsigned char>	&outData,
			size_t						outDataEstimatedSize);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			void						*inData,
			size_t						inDataSize,
			void						*outData,
			size_t						outDataBufferSize,
			size_t						&outDataActualSize);

		/** Decompress an array of bytes into another one
		  * \exception std::exception If the apriori estimated decompressed size is not enought
		  */
		void  decompress(
			CStream						&inStream,
			size_t						inDataSize,
			void						*outData,
			size_t						outDataBufferSize,
			size_t						&outDataActualSize);

	} // End of class def.

} // End of namespace

#endif
