/*---------------------------------------------------------------
	FILE: CServerTCPSocket.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CServerTCPSocket_H
#define  CServerTCPSocket_H

#include <MRPT/config.h>
#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CStream.h>


namespace UTILS
{
	class CClientTCPSocket;

	/** A TCP server socket.
	 */
	class CServerTCPSocket
	{
	private:
		/** The handle for the listening server TCP socket.
		  */
		unsigned int	m_serverSock;

		/** An event for signaling incoming connections.
		  */
		void			*m_serverAcceptEvent;

	public:
		/** Constructor that creates the socket, performs binding, and start listening mode.
		 */
		CServerTCPSocket(
			int	listenPort,
			const std::string &IPaddress = std::string("127.0.0.1")
			);

		/** Destructor
		 */
		~CServerTCPSocket( );

		/** Waits for an incoming connection (indefinitely, or with a given timeout)
		  * The returned object represents the new connection, and MUST BE deleted by the user when no longer needed.
		  * \param timeout_ms The timeout for the waiting, in milliseconds. Set this to "-1" to disable timeout (i.e. timeout=infinite)
		  * \return The incoming connection, or NULL if timeout.
		  */
		CClientTCPSocket *  accept( int timeout_ms = -1 );



	}; // End of class def.

} // End of namespace

#endif  // file
