/*---------------------------------------------------------------
	FILE: CMatrixD.h
	USE: Declares a "matrix" class. Also a type
	  for float elements matrix is defined as "CMatrixD"

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CMATRIXD_H
#define CMATRIXD_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/UTILS/CMatrixTemplateNumeric.h>
#include <MRPT/UTILS/utils_defs.h>


namespace UTILS
{
/**  This class is a "CSerializable" wrapper for "CMatrixTemplateNumeric<double>".
 */
class CMatrixD : public CSerializable, public CMatrixTemplateNumeric<double>
{
	// This must be added to any CSerializable derived class:
	DEFINE_SERIALIZABLE( CMatrixD )
public:
public:
	/** Constructor
	  */
	CMatrixD(size_t row = 3, size_t col = 3) : CMatrixTemplateNumeric<double>(row,col)
	{
	}

	/** Copy constructor
	  */
	CMatrixD( const CMatrixTemplateNumeric<double> &m ) : CMatrixTemplateNumeric<double>(m)
	{
	}

	/** Copy constructor
	  */
	CMatrixD( const CMatrixTemplateNumeric<float> &m ) : CMatrixTemplateNumeric<double>(0,0)
	{
		*this = m;
	}

	/** Assignment operator
	*/
	void  operator = (const CMatrixTemplateNumeric<double>& m)
	{
		CMatrixTemplateNumeric<double>::operator =(m);
	}

	/** Assignment operator
	*/
	void  operator = (const CMatrixTemplateNumeric<float>& m)
	{
		setSize(m.getRowCount(),m.getColCount());

		for (size_t i=0;i<m.getRowCount();i++)
			for (size_t j=0;j<m.getColCount();j++)
				(*this)(i,j) = (double)m(i,j);
	}

}; // end of class definition


} // End of namespace



#endif //__STD_MATRIX_H
