/*---------------------------------------------------------------
	FILE: MRML.h
	USE: The main "include file" of the library. This file
	       includes all the other ones, so user application
		   must include just this file and link against the
		   ".lib" file.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef MRML_H
#define MRML_H

// UTILITIES library classes and definitions:
// ---------------------------------------------
//#include <MRPT/UTILS/utils.h>

/**   See <A HREF="main.html#_mrml">main page</A> for a description of the contents of this namespace
 */
namespace MRML
{
	/** You must call MRML::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  */
	void registerAllClasses();
}

// Poses and points:
#include <MRPT/MRML/CPoseOrPoint.h>
#include <MRPT/MRML/CPoint2D.h>
#include <MRPT/MRML/CPoint3D.h>
#include <MRPT/MRML/CPose2D.h>
#include <MRPT/MRML/CPose3D.h>
#include <MRPT/MRML/CPoses2DSequence.h>
#include <MRPT/MRML/CPoses3DSequence.h>
#include <MRPT/MRML/CPose2DGridTemplate.h>

// Maps:
#include <MRPT/MRML/CMetricMap.h>
#include <MRPT/MRML/CPointsMap.h>
#include <MRPT/MRML/CSimplePointsMap.h>
#include <MRPT/MRML/COccupancyGridMap2D.h>
#include <MRPT/MRML/CMultiMetricMap.h>
#include <MRPT/MRML/CSensFrameProbSequence.h>
#include <MRPT/MRML/CLandmarksMap.h>
#include <MRPT/MRML/CLandmark.h>
#include <MRPT/MRML/CGasConcentrationGridMap2D.h>
#include <MRPT/MRML/CBeaconMap.h>

// Map Building algorithms:
#include <MRPT/MRML/CMetricMapBuilderICP.h>
#include <MRPT/MRML/CMetricMapBuilderRBPF.h>
#include <MRPT/MRML/CHierarchicalMappingFramework.h>

// Observations:
#include <MRPT/MRML/CObservation.h>
#include <MRPT/MRML/CObservation2DRangeScan.h>
#include <MRPT/MRML/CObservationRange.h>
#include <MRPT/MRML/CObservationImage.h>
#include <MRPT/MRML/CObservationVisualLandmarks.h>
#include <MRPT/MRML/CObservationStereoImages.h>
#include <MRPT/MRML/CObservationBeaconRanges.h>
#include <MRPT/MRML/CObservationGasSensors.h>
#include <MRPT/MRML/CObservationGPS.h>
#include <MRPT/MRML/CObservationBatteryState.h>

#include <MRPT/MRML/CSensorialFrame.h>

// Actions:
#include <MRPT/MRML/CActionCollection.h>
#include <MRPT/MRML/CActionRobotMovement2D.h>
#include <MRPT/MRML/CActionRobotMovement3D.h>


// Hierarchical maps:
#include <MRPT/MRML/CHierarchicalMap.h>
#include <MRPT/MRML/CHMapArc.h>
#include <MRPT/MRML/CHMapNode.h>


// Algorithms:
#include <MRPT/MRML/CConsistentObservationAlignment.h>
#include <MRPT/MRML/CICP.h>
#include <MRPT/MRML/ScanMatching.h>
#include <MRPT/MRML/CGridMapAligner.h>

#include <MRPT/MRML/CDetectorDoorCrossing.h>
#include <MRPT/MRML/CIncrementalMapPartitioner.h>
#include <MRPT/MRML/CPathPlanningMethod.h>
#include <MRPT/MRML/CPathPlanningCircularRobot.h>
#include <MRPT/MRML/CRejectionSamplingRangeOnlyLocalization.h>
#include <MRPT/MRML/CMonoSlamInterface.h>

// PDFs:
#include <MRPT/MRML/CPosePDFGaussian.h>
#include <MRPT/MRML/CPosePDFParticles.h>
#include <MRPT/MRML/CPosePDFGrid.h>
#include <MRPT/MRML/CPosePDFSOG.h>

#include <MRPT/MRML/CPose3DPDFGaussian.h>
#include <MRPT/MRML/CPose3DPDFParticles.h>

#include <MRPT/MRML/CPointPDFSOG.h>
#include <MRPT/MRML/CPointPDFGaussian.h>
#include <MRPT/MRML/CPointPDFParticles.h>

#include <MRPT/MRML/CHybridMetricMapPDF.h>

// Others:
#include <MRPT/MRML/CRobotSimulator.h>
#include <MRPT/MRML/CActionObservationSequence.h>
//#include <MRPT/MRML/CMonoSlam.h>




#endif
