/* -*- C++ -*- */
// POA_CORBA.h,v 1.34 1999/12/23 18:56:24 irfan Exp

// ============================================================================
//
// = LIBRARY
//    TAO
//
// = FILENAME
//   POA_CORBA.h
//
//   This file is created by merging the CurrentS.h, PolicyS.h,
//   PollableS.h, DomainC.h and DynAnyS.h files which have been removed.
//
// = AUTHOR
//
// ******  Code generated by the The ACE ORB (TAO) IDL Compiler *******
// TAO ORB and the TAO IDL Compiler have been developed by Washington
// University Computer Science's Distributed Object Computing Group.
//
// Information on TAO is available at
//                 http://www.cs.wustl.edu/~schmidt/TAO.html
//
//
// Modified by Aniruddha Gokhale.
//
// ============================================================================

#ifndef TAO_IDL_POA_CORBA_H
#define TAO_IDL_POA_CORBA_H

#include "tao/CurrentC.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PolicyC.h"
#include "tao/DynAnyC.h"
#include "tao/DomainC.h"
#include "tao/Servant_Base.h"
#if (TAO_HAS_AMI_POLLER == 1)
#include "tao/PollableC.h"
#endif /* TAO_HAS_AMI_POLLER == 1 */

#if defined(_MSC_VER)
#if (_MSC_VER >= 1200)
#pragma warning(push)
#endif /* _MSC_VER >= 1200 */
#pragma warning(disable:4250)
#endif /* _MSC_VER */

class TAO_Export  POA_CORBA
{
public:
  // ****************************************************************

  class Current;
  typedef Current *Current_ptr;
  class  Current :  public virtual TAO_Local_ServantBase
  {
  protected:
    Current (void);
  public:
    virtual ~Current (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ());
    virtual void* _downcast (
        const char* logical_type_id
      );

    ACE_CORBA_1(Current) *_this (CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ());
    virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef Current_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  };

  class  _tao_collocated_Current     : public virtual CORBA_Current
  {
  public:
    _tao_collocated_Current (void) {} // Needed by the IBM VisualAge C++ compiler.
    _tao_collocated_Current (
        Current_ptr  servant,
        TAO_Stub *stub
      );
    Current_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

  private:
    Current_ptr servant_;
  };

  // ****************************************************************

  class Policy;
  typedef Policy *Policy_ptr;

  class TAO_Export  Policy
#if defined (TAO_HAS_LOCALITY_CONSTRAINT_POLICIES)
    :  public virtual TAO_Locality_Constrained_ServantBase
#else
    :  public virtual TAO_ServantBase
#endif /* TAO_HAS_LOCALITY_CONSTRAINT_POLICIES */
  {
  protected:
    Policy (void);
  public:
    Policy (const Policy& rhs);
    virtual ~Policy (void);

    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ());

    virtual void* _downcast (
        const char* logical_type_id
      );

    virtual CORBA::PolicyType policy_type (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       ) = 0;

    virtual CORBA::Policy_ptr copy (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       ) = 0;

    virtual void destroy (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       ) = 0;

#if !defined (TAO_HAS_LOCALITY_CONSTRAINT_POLICIES)
    static void _get_policy_type_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

    static void copy_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

    static void destroy_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA_Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA_Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );
#endif /* !TAO_HAS_LOCALITY_CONSTRAINT_POLICIES */

    CORBA_Policy_ptr _this (
        CORBA_Environment &ACE_TRY_ENV =
          TAO_default_environment ());
    virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef Policy_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  };

  class TAO_Export  _tao_collocated_Policy     : public virtual CORBA_Policy
  {
  public:
    _tao_collocated_Policy (
        Policy_ptr  servant,
        TAO_Stub *stub
      );
    Policy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );
    virtual CORBA::PolicyType policy_type (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       );
    virtual CORBA::Policy_ptr copy (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       );
    virtual void destroy (
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
       );

  private:
    Policy_ptr servant_;
  };

  // ****************************************************************

  class PolicyManager;
  typedef PolicyManager *PolicyManager_ptr;
  class TAO_Export PolicyManager :  public virtual TAO_Local_ServantBase
  {
  protected:
    PolicyManager (void);
  public:
    PolicyManager (const PolicyManager& rhs);
    virtual ~PolicyManager (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual CORBA::PolicyList * get_policy_overrides (
        const CORBA::PolicyTypeSeq & ts,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    virtual void set_policy_overrides (
        const CORBA::PolicyList & policies,
        CORBA::SetOverrideType set_add,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    CORBA::PolicyManager *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
  };

  class TAO_Export _tao_collocated_PolicyManager     : public virtual CORBA::PolicyManager
  {
  public:
    _tao_collocated_PolicyManager (
        PolicyManager_ptr  servant,
        TAO_Stub *stub
      );
    PolicyManager_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::PolicyList * get_policy_overrides (
        const CORBA::PolicyTypeSeq & ts,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void set_policy_overrides (
        const CORBA::PolicyList & policies,
        CORBA::SetOverrideType set_add,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    PolicyManager_ptr servant_;
  };

  // ****************************************************************

  class PolicyCurrent;
  typedef PolicyCurrent *PolicyCurrent_ptr;
  class TAO_Export PolicyCurrent : public virtual PolicyManager, public virtual Current
  {
  protected:
    PolicyCurrent (void);
  public:
    PolicyCurrent (const PolicyCurrent& rhs);
    virtual ~PolicyCurrent (void);

    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void* _downcast (
        const char* logical_type_id
      );

    CORBA::PolicyCurrent *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual const char* _interface_repository_id (void) const;
  };

  class TAO_Export _tao_collocated_PolicyCurrent     : public virtual CORBA::PolicyCurrent,
      public virtual _tao_collocated_PolicyManager,
      public virtual _tao_collocated_Current
  {
  public:
    _tao_collocated_PolicyCurrent (
        PolicyCurrent_ptr  servant,
        TAO_Stub *stub
      );
    PolicyCurrent_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    PolicyCurrent_ptr servant_;
  };

  // ****************************************************************

  class DomainManager;
  typedef DomainManager *DomainManager_ptr;
  class  DomainManager :  public virtual PortableServer::ServantBase
  {
  protected:
    DomainManager (void);

  public:
    DomainManager (const DomainManager& rhs);
    virtual ~DomainManager (void);


    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual void* _downcast (
        const char* logical_type_id
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

        static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    CORBA::DomainManager *_this (
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual const char* _interface_repository_id (void) const;
    virtual CORBA::Policy_ptr get_domain_policy (
      CORBA::PolicyType policy_type,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    ) = 0;
    static void get_domain_policy_skel (
      CORBA::ServerRequest &_tao_req,
      void *_tao_obj,
      void *_tao_context,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    );

  };

  class  _tao_collocated_DomainManager : public virtual CORBA::DomainManager
  {
  public:
    _tao_collocated_DomainManager (
        DomainManager_ptr  servant,
        TAO_Stub *stub
      );
    DomainManager_ptr _get_servant (void) const;
        virtual CORBA::Policy_ptr get_domain_policy (
        CORBA::PolicyType policy_type,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

  private:
    DomainManager_ptr servant_;
  };

  // ****************************************************************

#if (TAO_HAS_AMI_POLLER == 1)

  class Pollable;
  typedef Pollable *Pollable_ptr;
  class TAO_Export Pollable :  public virtual PortableServer::ServantBase
  {
  protected:
    Pollable (void);
  public:
    Pollable (const Pollable& rhs);
    virtual ~Pollable (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual CORBA::Boolean is_ready (
        CORBA::ULong timeout,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void is_ready_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual CORBA::PollableSet_ptr create_pollable_set (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void create_pollable_set_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::Pollable *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
  };

  class TAO_Export _tao_collocated_Pollable     : public virtual CORBA::Pollable
  {
  public:
    _tao_collocated_Pollable (
        Pollable_ptr  servant,
        TAO_Stub *stub
      );
    Pollable_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::Boolean is_ready (
        CORBA::ULong timeout,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::PollableSet_ptr create_pollable_set (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    Pollable_ptr servant_;
  };

  // ****************************************************************

  class DIIPollable;
  typedef DIIPollable *DIIPollable_ptr;
  class TAO_Export DIIPollable : public virtual Pollable
  {
  protected:
    DIIPollable (void);
  public:
    DIIPollable (const DIIPollable& rhs);
    virtual ~DIIPollable (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::Boolean in_mult_inheritance (void);

    static void is_ready_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void create_pollable_set_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::DIIPollable *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
  };

  class TAO_Export _tao_collocated_DIIPollable     : public virtual CORBA::DIIPollable,
      public virtual _tao_collocated_Pollable
  {
  public:
    _tao_collocated_DIIPollable (
        DIIPollable_ptr  servant,
        TAO_Stub *stub
      );
    DIIPollable_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    DIIPollable_ptr servant_;
  };

  // ****************************************************************

  class PollableSet;
  typedef PollableSet *PollableSet_ptr;
  class TAO_Export PollableSet :  public virtual PortableServer::ServantBase
  {
  protected:
    PollableSet (void);
  public:
    PollableSet (const PollableSet& rhs);
    virtual ~PollableSet (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual CORBA::DIIPollable_ptr create_dii_pollable (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void create_dii_pollable_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void add_pollable (
        CORBA::Pollable_ptr potential,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void add_pollable_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual CORBA::Pollable_ptr poll (
        CORBA::ULong timeout,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void poll_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void remove (
        CORBA::Pollable_ptr potential,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void remove_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual CORBA::UShort number_left (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void number_left_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::PollableSet *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
  };

  class TAO_Export _tao_collocated_PollableSet : public virtual CORBA::PollableSet
  {
  public:
    _tao_collocated_PollableSet (
        PollableSet_ptr  servant,
        TAO_Stub *stub
      );
    PollableSet_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::DIIPollable_ptr create_dii_pollable (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void add_pollable (
        CORBA::Pollable_ptr potential,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::Pollable_ptr poll (
        CORBA::ULong timeout,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void remove (
        CORBA::Pollable_ptr potential,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::UShort number_left (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    PollableSet_ptr servant_;
  };
#endif /* TAO_HAS_AMI_POLLER == 1 */

  // ****************************************************************

#if !defined (TAO_HAS_MINIMUM_CORBA)

class DynAny;
typedef DynAny *DynAny_ptr;
class TAO_Export DynAny : public virtual TAO_Local_ServantBase
{
protected:
  DynAny (void);
public:
  DynAny (DynAny& rhs);
  virtual ~DynAny (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual CORBA::TypeCode_ptr type (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void assign (
      CORBA_DynAny_ptr dyn_any,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void from_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual CORBA::Any * to_any (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual CORBA_DynAny_ptr copy (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void insert_boolean (
      CORBA::Boolean value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void insert_octet (
      CORBA::Octet value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_char (
      CORBA::Char value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_short (
      CORBA::Short value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_ushort (
      CORBA::UShort value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_long (
      CORBA::Long value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_ulong (
      CORBA::ULong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_float (
      CORBA::Float value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_double (
      CORBA::Double value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_string (
      const char * value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_reference (
      CORBA::Object_ptr value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_typecode (
      CORBA::TypeCode_ptr value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_longlong (
      CORBA::LongLong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_ulonglong (
      CORBA::ULongLong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_wchar (
      CORBA::WChar value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void insert_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Boolean get_boolean (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual CORBA::Octet get_octet (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Char get_char (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Short get_short (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::UShort get_ushort (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Long get_long (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::ULong get_ulong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Float get_float (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Double get_double (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual char * get_string (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Object_ptr get_reference (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::TypeCode_ptr get_typecode (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::LongLong get_longlong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::ULongLong get_ulonglong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::WChar get_wchar (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::Any * get_any (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA_DynAny_ptr current_component (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual CORBA::Boolean next (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual CORBA::Boolean seek (
      CORBA::Long slot,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  virtual void rewind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
        ) = 0;

  CORBA_DynAny *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynAny_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynAny : public virtual CORBA_DynAny
{
public:
  _tao_collocated_DynAny (
      DynAny_ptr  servant,
      TAO_Stub *stub
     );
  DynAny_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual CORBA::TypeCode_ptr type (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void assign (
      CORBA_DynAny_ptr CORBA_Dyn_any,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void from_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Any * to_any (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr copy (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_boolean (
      CORBA::Boolean value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_octet (
      CORBA::Octet value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_char (
      CORBA::Char value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_short (
      CORBA::Short value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ushort (
      CORBA::UShort value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_long (
      CORBA::Long value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ulong (
      CORBA::ULong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_float (
      CORBA::Float value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_double (
      CORBA::Double value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_string (
      const char * value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_reference (
      CORBA::Object_ptr value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_typecode (
      CORBA::TypeCode_ptr value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_longlong (
      CORBA::LongLong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ulonglong (
      CORBA::ULongLong value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_wchar (
      CORBA::WChar value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean get_boolean (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Octet get_octet (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Char get_char (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Short get_short (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::UShort get_ushort (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Long get_long (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULong get_ulong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Float get_float (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Double get_double (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual char * get_string (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Object_ptr get_reference (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TypeCode_ptr get_typecode (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::LongLong get_longlong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULongLong get_ulonglong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::WChar get_wchar (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Any * get_any (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr current_component (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean next (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean seek (
      CORBA::Long slot,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void rewind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynAny_ptr servant_;
};

class DynEnum;
typedef DynEnum *DynEnum_ptr;
class TAO_Export DynEnum : public virtual DynAny
{
protected:
  DynEnum (void);
public:
  DynEnum (DynEnum& rhs);
  virtual ~DynEnum (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual char * value_as_string (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void value_as_string (
      const char * value_as_string,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::ULong value_as_ulong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void value_as_ulong (
      CORBA::ULong value_as_ulong,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  CORBA_DynEnum *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynEnum_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynEnum : public virtual CORBA_DynEnum,
    public virtual _tao_collocated_DynAny
{
public:
  _tao_collocated_DynEnum (
      DynEnum_ptr  servant,
      TAO_Stub *stub
    );
  DynEnum_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual char * value_as_string (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void value_as_string (
      const char * value_as_string,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULong value_as_ulong (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void value_as_ulong (
      CORBA::ULong value_as_ulong,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynEnum_ptr servant_;
};

class DynStruct;
typedef DynStruct *DynStruct_ptr;
class TAO_Export DynStruct : public virtual DynAny
{
protected:
  DynStruct (void);
public:
  DynStruct (DynStruct& rhs);
  virtual ~DynStruct (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual char * current_member_name (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::TCKind current_member_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::NameValuePairSeq * get_members (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void set_members (
      const CORBA::NameValuePairSeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  CORBA_DynStruct *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynStruct_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynStruct : public virtual CORBA_DynStruct,
    public virtual _tao_collocated_DynAny
{
public:
  _tao_collocated_DynStruct (
      DynStruct_ptr  servant,
      TAO_Stub *stub
    );
  DynStruct_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual char * current_member_name (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind current_member_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::NameValuePairSeq * get_members (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void set_members (
      const CORBA::NameValuePairSeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynStruct_ptr servant_;
};

class DynUnion;
typedef DynUnion *DynUnion_ptr;
class TAO_Export DynUnion : public virtual DynAny
{
protected:
  DynUnion (void);
public:
  DynUnion (DynUnion& rhs);
  virtual ~DynUnion (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual CORBA::Boolean set_as_default (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void set_as_default (
      CORBA::Boolean set_as_default,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA_DynAny_ptr discriminator (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::TCKind discriminator_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA_DynAny_ptr member (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual char * member_name (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void member_name (
      const char * member_name,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA::TCKind member_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  CORBA_DynUnion *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynUnion_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynUnion : public virtual CORBA_DynUnion,
    public virtual _tao_collocated_DynAny
{
public:
  _tao_collocated_DynUnion (
      DynUnion_ptr  servant,
      TAO_Stub *stub
    );
  DynUnion_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual CORBA::Boolean set_as_default (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void set_as_default (
      CORBA::Boolean set_as_default,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr discriminator (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind discriminator_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr member (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual char * member_name (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void member_name (
      const char * member_name,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind member_kind (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynUnion_ptr servant_;
};

class DynSequence;
typedef DynSequence *DynSequence_ptr;
class TAO_Export DynSequence : public virtual DynAny
{
protected:
  DynSequence (void);
public:
  DynSequence (DynSequence& rhs);
  virtual ~DynSequence (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual CORBA::ULong length (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void length (
      CORBA::ULong length,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  static void type_skel (
      CORBA::ServerRequest &req,
      void *obj,
      void *context,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );

  CORBA_DynSequence *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynSequence_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynSequence : public virtual CORBA_DynSequence,
    public virtual _tao_collocated_DynAny
{
public:
  _tao_collocated_DynSequence (
      DynSequence_ptr  servant,
      TAO_Stub *stub
    );
  DynSequence_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual CORBA::ULong length (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void length (
      CORBA::ULong length,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynSequence_ptr servant_;
};

class DynArray;
typedef DynArray *DynArray_ptr;
class TAO_Export DynArray : public virtual DynAny
{
protected:
  DynArray (void);
public:
  DynArray (DynArray& rhs);
  virtual ~DynArray (void);
  virtual CORBA::Boolean _is_a (
      const char* logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual void* _downcast (
      const char* logical_type_id
    );
  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     ) = 0;

  CORBA_DynArray *_this (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef DynArray_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class  _tao_collocated_DynArray : public virtual CORBA_DynArray,
    public virtual _tao_collocated_DynAny
{
public:
  _tao_collocated_DynArray (
      DynArray_ptr  servant,
      TAO_Stub *stub
    );
  DynArray_ptr _get_servant (void) const;
  virtual CORBA::Boolean _is_a (
      const char *logical_type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );
  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
     );

private:
  DynArray_ptr servant_;
};

  class ConstructionPolicy;
  typedef ConstructionPolicy *ConstructionPolicy_ptr;
  class  ConstructionPolicy : public virtual Policy
  {
  protected:
    ConstructionPolicy (void);

  public:
    ConstructionPolicy (const ConstructionPolicy& rhs);
    virtual ~ConstructionPolicy (void);


    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual void* _downcast (
        const char* logical_type_id
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

        static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    CORBA::ConstructionPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );

    virtual const char* _interface_repository_id (void) const;
    virtual void make_domain_manager (
      CORBA::InterfaceDef_ptr object_type,
      CORBA::Boolean constr_policy,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    ) = 0;
  static void make_domain_manager_skel (
      CORBA::ServerRequest &_tao_req,
      void *_tao_obj,
      void *_tao_context,
      CORBA::Environment &ACE_TRY_ENV =
        TAO_default_environment ()
    );

  };

  class  _tao_collocated_ConstructionPolicy : public virtual CORBA::ConstructionPolicy,
      public virtual _tao_collocated_Policy
  {
  public:
    _tao_collocated_ConstructionPolicy (
        ConstructionPolicy_ptr  servant,
        TAO_Stub *stub
      );
    ConstructionPolicy_ptr _get_servant (void) const;
        virtual void make_domain_manager (
        CORBA::InterfaceDef_ptr object_type,
        CORBA::Boolean constr_policy,
        CORBA::Environment &ACE_TRY_ENV =
          TAO_default_environment ()
      );
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    ConstructionPolicy_ptr servant_;
  };

#endif /* ! defined TAO_HAS_MINIMUM_CORBA */
};

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
#pragma warning(pop)
#endif /* _MSC_VER */

#endif /* TAO_IDL_POA_CORBA_H */
