/* -*- C++ -*- */
// DynAnyC.h,v 1.27 2000/03/02 02:36:01 coryan Exp
// ============================================================================
//
// = LIBRARY
//    TAO
//
// = FILENAME
//    DynAnyC.h
//
// = AUTHOR
//
// ******  Code generated by the The ACE ORB (TAO) IDL Compiler *******
// TAO ORB and the TAO IDL Compiler have been developed by Washington
// University Computer Science's Distributed Object Computing Group.
//
// Information on TAO is available at
//                 http://www.cs.wustl.edu/~schmidt/TAO.html
//
//
// Modified by Jeff Parsons <parsons@cs.wustl.edu>
//
// ============================================================================

#ifndef TAO_IDL_CORBA_DYNANYC_H_
#define TAO_IDL_CORBA_DYNANYC_H_

#include "tao/orbconf.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if !defined (TAO_HAS_MINIMUM_CORBA)

#include "tao/corbafwd.h"
#include "tao/Any.h"
#include "tao/Object.h"
#include "tao/Sequence.h"

#if defined (TAO_EXPORT_MACRO)
#undef TAO_EXPORT_MACRO
#endif
#define TAO_EXPORT_MACRO
#if defined(_MSC_VER)
#if (_MSC_VER >= 1200)
#pragma warning(push)
#endif /* _MSC_VER >= 1200 */
#pragma warning(disable:4250)
#endif /* _MSC_VER */


class CORBA_DynAny;
typedef CORBA_DynAny *CORBA_DynAny_ptr;

class TAO_Export CORBA_DynAny_var
{
public:
  CORBA_DynAny_var (void); // default constructor
  CORBA_DynAny_var (CORBA_DynAny_ptr);
  CORBA_DynAny_var (const CORBA_DynAny_var &); // copy constructor
  ~CORBA_DynAny_var (void); // destructor

  CORBA_DynAny_var &operator= (CORBA_DynAny_ptr);
  CORBA_DynAny_var &operator= (const CORBA_DynAny_var &);
  CORBA_DynAny_ptr operator-> (void) const;

  operator const CORBA_DynAny_ptr &() const;
  operator CORBA_DynAny_ptr &();

  // in, inout, out, _retn
  CORBA_DynAny_ptr in (void) const;
  CORBA_DynAny_ptr &inout (void);
  CORBA_DynAny_ptr &out (void);
  CORBA_DynAny_ptr _retn (void);
  CORBA_DynAny_ptr ptr (void) const;

private:
  CORBA_DynAny_ptr ptr_;
};

class TAO_Export CORBA_DynAny_out
{
public:
  CORBA_DynAny_out (CORBA_DynAny_ptr &);
  CORBA_DynAny_out (CORBA_DynAny_var &);
  CORBA_DynAny_out (const CORBA_DynAny_out &);
  CORBA_DynAny_out &operator= (const CORBA_DynAny_out &);
  CORBA_DynAny_out &operator= (const CORBA_DynAny_var &);
  CORBA_DynAny_out &operator= (CORBA_DynAny_ptr);
  operator CORBA_DynAny_ptr &();
  CORBA_DynAny_ptr &ptr (void);
  CORBA_DynAny_ptr operator-> (void);

private:
  CORBA_DynAny_ptr &ptr_;
};

class TAO_Export CORBA_DynAny : public virtual ACE_CORBA_1 (Object)
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynAny_ptr _ptr_type;
    typedef CORBA_DynAny_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynAny_ptr _duplicate (CORBA_DynAny_ptr obj);
  static CORBA_DynAny_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynAny_ptr _nil (void);

  class Invalid;
  typedef Invalid *Invalid_ptr;

  class TAO_Export Invalid : public CORBA::UserException
  {
  public:
    Invalid (void); // default ctor
    Invalid (const Invalid &); // copy ctor
    ~Invalid (void); // dtor
    Invalid &operator= (const Invalid &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static Invalid *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef Invalid_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  }; // exception CORBA_DynAny::Invalid

    static CORBA::TypeCode_ptr _tc_Invalid;

  class InvalidValue;
  typedef InvalidValue *InvalidValue_ptr;

  class TAO_Export InvalidValue : public CORBA::UserException
  {
  public:
    InvalidValue (void); // default ctor
    InvalidValue (const InvalidValue &); // copy ctor
    ~InvalidValue (void); // dtor
    InvalidValue &operator= (const InvalidValue &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static InvalidValue *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef InvalidValue_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  }; // exception CORBA_DynAny::InvalidValue

    static CORBA::TypeCode_ptr _tc_InvalidValue;

  class TypeMismatch;
  typedef TypeMismatch *TypeMismatch_ptr;

  class TAO_Export TypeMismatch : public CORBA::UserException
  {
  public:
    TypeMismatch (void); // default ctor
    TypeMismatch (const TypeMismatch &); // copy ctor
    ~TypeMismatch (void); // dtor
    TypeMismatch &operator= (const TypeMismatch &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static TypeMismatch *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef TypeMismatch_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  }; // exception CORBA_DynAny::TypeMismatch

    static CORBA::TypeCode_ptr _tc_TypeMismatch;

  class InvalidSeq;
  typedef InvalidSeq *InvalidSeq_ptr;

  class TAO_Export InvalidSeq : public CORBA::UserException
  {
  public:
    InvalidSeq (void); // default ctor
    InvalidSeq (const InvalidSeq &); // copy ctor
    ~InvalidSeq (void); // dtor
    InvalidSeq &operator= (const InvalidSeq &);


    virtual void _raise (void);

    virtual void _tao_encode (TAO_OutputCDR &cdr,
                              CORBA::Environment &) const;
    virtual void _tao_decode (TAO_InputCDR &cdr,
                              CORBA::Environment &);

    static InvalidSeq *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef InvalidSeq_ptr _ptr_type;
#endif /* __GNUC__ */
  // Useful for template programming.

  }; // exception CORBA_DynAny::InvalidSeq

    static CORBA::TypeCode_ptr _tc_InvalidSeq;

  virtual CORBA::TypeCode_ptr type (
      CORBA::Environment &ACE_TRY_ENVironment =
      CORBA::Environment::default_environment ()
     );
  virtual void assign (
      CORBA_DynAny_ptr dyn_any,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void from_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Any * to_any (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr copy (
      CORBA::Environment &ACE_TRY_ENVironment =
      CORBA::Environment::default_environment ()
     );
  virtual void insert_boolean (
      CORBA::Boolean value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_octet (
      CORBA::Octet value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_char (
      CORBA::Char value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_short (
      CORBA::Short value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ushort (
      CORBA::UShort value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_long (
      CORBA::Long value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ulong (
      CORBA::ULong value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_float (
      CORBA::Float value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_double (
      CORBA::Double value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_string (
      const char * value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_reference (
      CORBA::Object_ptr value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_typecode (
      CORBA::TypeCode_ptr value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_longlong (
      CORBA::LongLong value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_ulonglong (
      CORBA::ULongLong value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_wchar (
      CORBA::WChar value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void insert_any (
      const CORBA::Any & value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean get_boolean (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Octet get_octet (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Char get_char (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Short get_short (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::UShort get_ushort (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Long get_long (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULong get_ulong (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Float get_float (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Double get_double (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual char * get_string (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Object_ptr get_reference (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TypeCode_ptr get_typecode (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::LongLong get_longlong (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULongLong get_ulonglong (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::WChar get_wchar (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Any * get_any (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr current_component (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean next (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean seek (
      CORBA::Long slot,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void rewind (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynAny (void); // default constructor
  CORBA_DynAny (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynAny (void);
private:
  CORBA_DynAny (const CORBA_DynAny &);
  void operator= (const CORBA_DynAny &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynAny;

class CORBA_DynEnum;
typedef CORBA_DynEnum *CORBA_DynEnum_ptr;

class TAO_Export CORBA_DynEnum_var
{
public:
  CORBA_DynEnum_var (void); // default constructor
  CORBA_DynEnum_var (CORBA_DynEnum_ptr);
  CORBA_DynEnum_var (const CORBA_DynEnum_var &); // copy constructor
  ~CORBA_DynEnum_var (void); // destructor

  CORBA_DynEnum_var &operator= (CORBA_DynEnum_ptr);
  CORBA_DynEnum_var &operator= (const CORBA_DynEnum_var &);
  CORBA_DynEnum_ptr operator-> (void) const;

  operator const CORBA_DynEnum_ptr &() const;
  operator CORBA_DynEnum_ptr &();
  // in, inout, out, _retn
  CORBA_DynEnum_ptr in (void) const;
  CORBA_DynEnum_ptr &inout (void);
  CORBA_DynEnum_ptr &out (void);
  CORBA_DynEnum_ptr _retn (void);
  CORBA_DynEnum_ptr ptr (void) const;

private:
  CORBA_DynEnum_ptr ptr_;
};

class TAO_Export CORBA_DynEnum_out
{
public:
  CORBA_DynEnum_out (CORBA_DynEnum_ptr &);
  CORBA_DynEnum_out (CORBA_DynEnum_var &);
  CORBA_DynEnum_out (const CORBA_DynEnum_out &);
  CORBA_DynEnum_out &operator= (const CORBA_DynEnum_out &);
  CORBA_DynEnum_out &operator= (const CORBA_DynEnum_var &);
  CORBA_DynEnum_out &operator= (CORBA_DynEnum_ptr);
  operator CORBA_DynEnum_ptr &();
  CORBA_DynEnum_ptr &ptr (void);
  CORBA_DynEnum_ptr operator-> (void);

private:
  CORBA_DynEnum_ptr &ptr_;
};

class TAO_Export CORBA_DynEnum: public virtual CORBA_DynAny
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynEnum_ptr _ptr_type;
    typedef CORBA_DynEnum_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynEnum_ptr _duplicate (CORBA_DynEnum_ptr obj);
  static CORBA_DynEnum_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynEnum_ptr _nil (void);

  virtual char * value_as_string (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void value_as_string (
      const char * value_as_string,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::ULong value_as_ulong (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void value_as_ulong (
      CORBA::ULong value_as_ulong,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynEnum (void); // default constructor
  CORBA_DynEnum (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynEnum (void);
private:
  CORBA_DynEnum (const CORBA_DynEnum &);
  void operator= (const CORBA_DynEnum &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynEnum;

// Forward declaration.
struct CORBA_NameValuePair;

class TAO_Export CORBA_NameValuePair_var
{
public:
  CORBA_NameValuePair_var (void); // default constructor
  CORBA_NameValuePair_var (CORBA_NameValuePair *);
  CORBA_NameValuePair_var (const CORBA_NameValuePair_var &); // copy constructor
  ~CORBA_NameValuePair_var (void); // destructor

  CORBA_NameValuePair_var &operator= (CORBA_NameValuePair *);
  CORBA_NameValuePair_var &operator= (const CORBA_NameValuePair_var &);
  CORBA_NameValuePair *operator-> (void);
  const CORBA_NameValuePair *operator-> (void) const;

  operator const CORBA_NameValuePair &() const;
  operator CORBA_NameValuePair &();
  operator CORBA_NameValuePair &() const;
  // in, inout, out, _retn
  const CORBA_NameValuePair &in (void) const;
  CORBA_NameValuePair &inout (void);
  CORBA_NameValuePair *&out (void);
  CORBA_NameValuePair *_retn (void);
  CORBA_NameValuePair *ptr (void) const;

private:
  CORBA_NameValuePair *ptr_;
};

class TAO_Export CORBA_NameValuePair_out
{
public:
  CORBA_NameValuePair_out (CORBA_NameValuePair *&);
  CORBA_NameValuePair_out (CORBA_NameValuePair_var &);
  CORBA_NameValuePair_out (const CORBA_NameValuePair_out &);
  CORBA_NameValuePair_out &operator= (const CORBA_NameValuePair_out &);
  CORBA_NameValuePair_out &operator= (CORBA_NameValuePair *);
  operator CORBA_NameValuePair *&();
  CORBA_NameValuePair *&ptr (void);
  CORBA_NameValuePair *operator-> (void);

private:
  CORBA_NameValuePair *&ptr_;
  // assignment from T_var not allowed
  void operator= (const CORBA_NameValuePair_var &);
};

struct TAO_Export CORBA_NameValuePair
{
  TAO_String_Manager id;
  CORBA::Any value;

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef CORBA_NameValuePair_ptr _ptr_type;
  typedef CORBA_NameValuePair_var _var_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq : public TAO_Unbounded_Base_Sequence
{
public:
  // = Initialization and termination methods.

  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq (void) // Default constructor.
  {
  }

  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq (CORBA::ULong maximum) // Constructor using a maximum length value.
    : TAO_Unbounded_Base_Sequence (maximum, allocbuf (maximum))
  {
  }

  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq (CORBA::ULong maximum,
    CORBA::ULong length,
    CORBA_NameValuePair *data,
    CORBA::Boolean release = 0)
  : TAO_Unbounded_Base_Sequence (maximum, length, data, release)
  {
  }

  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq (const _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq &rhs)
  // Copy constructor.
    : TAO_Unbounded_Base_Sequence (rhs)
  {
    CORBA_NameValuePair *tmp1 = allocbuf (this->maximum_);
    CORBA_NameValuePair * const tmp2 = ACE_reinterpret_cast (CORBA_NameValuePair * ACE_CAST_CONST, rhs.buffer_);

    for (CORBA::ULong i = 0; i < this->length_; ++i)
      tmp1[i] = tmp2[i];

    this->buffer_ = tmp1;
  }

  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq &operator= (const _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq &rhs)
  // Assignment operator.
  {
    if (this == &rhs)
      return *this;

    if (this->release_)
    {
      if (this->maximum_ < rhs.maximum_)
      {
        // free the old buffer
        CORBA_NameValuePair *tmp = ACE_reinterpret_cast (CORBA_NameValuePair *, this->buffer_);
        freebuf (tmp);
        this->buffer_ = allocbuf (rhs.maximum_);
      }
    }
    else
      this->buffer_ = allocbuf (rhs.maximum_);

    TAO_Unbounded_Base_Sequence::operator= (rhs);

    CORBA_NameValuePair *tmp1 = ACE_reinterpret_cast (CORBA_NameValuePair *, this->buffer_);
    CORBA_NameValuePair * const tmp2 = ACE_reinterpret_cast (CORBA_NameValuePair * ACE_CAST_CONST, rhs.buffer_);

    for (CORBA::ULong i = 0; i < this->length_; ++i)
      tmp1[i] = tmp2[i];

    return *this;
  }

  ~_TAO_Unbounded_Sequence_CORBA_NameValuePairSeq (void) // Dtor.
  {
    this->_deallocate_buffer ();
  }

  // = Accessors.
  CORBA_NameValuePair &operator[] (CORBA::ULong i)
  // operator []
  {
    ACE_ASSERT (i < this->maximum_);
    CORBA_NameValuePair* tmp = ACE_reinterpret_cast(CORBA_NameValuePair*,this->buffer_);
    return tmp[i];
  }

  const CORBA_NameValuePair &operator[] (CORBA::ULong i) const
  // operator []
  {
    ACE_ASSERT (i < this->maximum_);
    CORBA_NameValuePair * const tmp = ACE_reinterpret_cast (CORBA_NameValuePair* ACE_CAST_CONST, this->buffer_);
    return tmp[i];
  }

  // = Static operations.
  static CORBA_NameValuePair *allocbuf (CORBA::ULong size)
  // Allocate storage for the sequence.
  {
    return new CORBA_NameValuePair[size];
  }

  static void freebuf (CORBA_NameValuePair *buffer)
  // Free the sequence.
  {
    delete [] buffer;
  }

  virtual void _allocate_buffer (CORBA::ULong length)
  {
    CORBA_NameValuePair* tmp = allocbuf (length);

    if (this->buffer_ != 0)
    {
      CORBA_NameValuePair *old = ACE_reinterpret_cast (CORBA_NameValuePair *,this->buffer_);

      for (CORBA::ULong i = 0; i < this->length_; ++i)
        tmp[i] = old[i];

      if (this->release_)
        freebuf (old);

    }
    this->buffer_ = tmp;
  }

  virtual void _deallocate_buffer (void)
  {
    if (this->buffer_ == 0 || this->release_ == 0)
      return;

    CORBA_NameValuePair *tmp = ACE_reinterpret_cast (CORBA_NameValuePair *,this->buffer_);

    freebuf (tmp);
    this->buffer_ = 0;
  }

  // Implement the TAO_Base_Sequence methods (see Sequence.h)

  CORBA_NameValuePair *get_buffer (CORBA::Boolean orphan = 0)
  {
    CORBA_NameValuePair *result = 0;
    if (orphan == 0)
    {
      // We retain ownership.
      if (this->buffer_ == 0)
      {
        result = allocbuf (this->length_);
        this->buffer_ = result;
      }
      else
      {
        result = ACE_reinterpret_cast (CORBA_NameValuePair*, this->buffer_);
      }
    }
    else // if (orphan == 1)
    {
      if (this->release_ != 0)
      {
        // We set the state back to default and relinquish
        // ownership.
        result = ACE_reinterpret_cast(CORBA_NameValuePair*,this->buffer_);
        this->maximum_ = 0;
        this->length_ = 0;
        this->buffer_ = 0;
        this->release_ = 0;
      }
    }
    return result;
  }

  const CORBA_NameValuePair *get_buffer (void) const
  {
    return ACE_reinterpret_cast(const CORBA_NameValuePair * ACE_CAST_CONST, this->buffer_);
  }

  void replace (CORBA::ULong max,
  CORBA::ULong length,
  CORBA_NameValuePair *data,
  CORBA::Boolean release)
  {
    this->maximum_ = max;
    this->length_ = length;
    if (this->buffer_ && this->release_ == 1)
    {
      CORBA_NameValuePair *tmp = ACE_reinterpret_cast(CORBA_NameValuePair*,this->buffer_);
      freebuf (tmp);
    }
    this->buffer_ = data;
    this->release_ = release;
  }

};

// *************************************************************
// class CORBA::NameValuePairSeq_var
// *************************************************************

class TAO_Export CORBA_NameValuePairSeq_var
{
public:
  CORBA_NameValuePairSeq_var (void); // default constructor
  CORBA_NameValuePairSeq_var (CORBA_NameValuePairSeq *);
  CORBA_NameValuePairSeq_var (const CORBA_NameValuePairSeq_var &); // copy constructor
  ~CORBA_NameValuePairSeq_var (void); // destructor

  CORBA_NameValuePairSeq_var &operator= (CORBA_NameValuePairSeq *);
  CORBA_NameValuePairSeq_var &operator= (const CORBA_NameValuePairSeq_var &);
  CORBA_NameValuePairSeq *operator-> (void);
  const CORBA_NameValuePairSeq *operator-> (void) const;

  operator const CORBA_NameValuePairSeq &() const;
  operator CORBA_NameValuePairSeq &();
  operator CORBA_NameValuePairSeq &() const;
  CORBA_NameValuePair &operator[] (CORBA::ULong slot);
  // in, inout, out, _retn
  const CORBA_NameValuePairSeq &in (void) const;
  CORBA_NameValuePairSeq &inout (void);
  CORBA_NameValuePairSeq *&out (void);
  CORBA_NameValuePairSeq *_retn (void);
  CORBA_NameValuePairSeq *ptr (void) const;

private:
  CORBA_NameValuePairSeq *ptr_;
};

class TAO_Export CORBA_NameValuePairSeq_out
{
public:
  CORBA_NameValuePairSeq_out (CORBA_NameValuePairSeq *&);
  CORBA_NameValuePairSeq_out (CORBA_NameValuePairSeq_var &);
  CORBA_NameValuePairSeq_out (const CORBA_NameValuePairSeq_out &);
  CORBA_NameValuePairSeq_out &operator= (const CORBA_NameValuePairSeq_out &);
  CORBA_NameValuePairSeq_out &operator= (CORBA_NameValuePairSeq *);
  operator CORBA_NameValuePairSeq *&();
  CORBA_NameValuePairSeq *&ptr (void);
  CORBA_NameValuePairSeq *operator-> (void);
  CORBA_NameValuePair &operator[] (CORBA::ULong slot);

private:
  CORBA_NameValuePairSeq *&ptr_;
  // assignment from T_var not allowed
  void operator= (const CORBA_NameValuePairSeq_var &);
};

// *************************************************************
// CORBA::NameValuePairSeq
// *************************************************************
class TAO_Export CORBA_NameValuePairSeq : public
#if defined (ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION) \
       || defined (ACE_HAS_TEMPLATE_INSTANTIATION_PRAGMA) \
       || !defined (ACE_HAS_TEMPLATE_SPECIALIZATION)
  _TAO_Unbounded_Sequence_CORBA_NameValuePairSeq
#else /* AHETI */
  TAO_Unbounded_Sequence<CORBA_NameValuePair>
#endif /* AHETI */
{
public:
  CORBA_NameValuePairSeq (void); // default ctor
  CORBA_NameValuePairSeq (CORBA::ULong max); // uses max size
  CORBA_NameValuePairSeq (
    CORBA::ULong max,
    CORBA::ULong length,
    CORBA_NameValuePair *buffer,
    CORBA::Boolean release=0
  );
  CORBA_NameValuePairSeq (const CORBA_NameValuePairSeq &); // copy ctor
  ~CORBA_NameValuePairSeq (void); // dtor

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef CORBA_NameValuePairSeq_ptr _ptr_type;
  typedef CORBA_NameValuePairSeq_var _var_type;
#endif /* __GNUC__ */
  // Useful for template programming.

};

class CORBA_DynStruct;
typedef CORBA_DynStruct *CORBA_DynStruct_ptr;

class TAO_Export CORBA_DynStruct_var
{
public:
  CORBA_DynStruct_var (void); // default constructor
  CORBA_DynStruct_var (CORBA_DynStruct_ptr);
  CORBA_DynStruct_var (const CORBA_DynStruct_var &); // copy constructor
  ~CORBA_DynStruct_var (void); // destructor

  CORBA_DynStruct_var &operator= (CORBA_DynStruct_ptr);
  CORBA_DynStruct_var &operator= (const CORBA_DynStruct_var &);
  CORBA_DynStruct_ptr operator-> (void) const;

  operator const CORBA_DynStruct_ptr &() const;
  operator CORBA_DynStruct_ptr &();
  // in, inout, out, _retn
  CORBA_DynStruct_ptr in (void) const;
  CORBA_DynStruct_ptr &inout (void);
  CORBA_DynStruct_ptr &out (void);
  CORBA_DynStruct_ptr _retn (void);
  CORBA_DynStruct_ptr ptr (void) const;

private:
  CORBA_DynStruct_ptr ptr_;
};

class TAO_Export CORBA_DynStruct_out
{
public:
  CORBA_DynStruct_out (CORBA_DynStruct_ptr &);
  CORBA_DynStruct_out (CORBA_DynStruct_var &);
  CORBA_DynStruct_out (const CORBA_DynStruct_out &);
  CORBA_DynStruct_out &operator= (const CORBA_DynStruct_out &);
  CORBA_DynStruct_out &operator= (const CORBA_DynStruct_var &);
  CORBA_DynStruct_out &operator= (CORBA_DynStruct_ptr);
  operator CORBA_DynStruct_ptr &();
  CORBA_DynStruct_ptr &ptr (void);
  CORBA_DynStruct_ptr operator-> (void);

private:
  CORBA_DynStruct_ptr &ptr_;
};

class TAO_Export CORBA_DynStruct: public virtual CORBA_DynAny
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynStruct_ptr _ptr_type;
    typedef CORBA_DynStruct_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynStruct_ptr _duplicate (CORBA_DynStruct_ptr obj);
  static CORBA_DynStruct_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynStruct_ptr _nil (void);

  virtual char * current_member_name (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind current_member_kind (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_NameValuePairSeq * get_members (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void set_members (
      const CORBA_NameValuePairSeq & value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynStruct (void); // default constructor
  CORBA_DynStruct (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynStruct (void);
private:
  CORBA_DynStruct (const CORBA_DynStruct &);
  void operator= (const CORBA_DynStruct &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynStruct;

class CORBA_DynUnion;
typedef CORBA_DynUnion *CORBA_DynUnion_ptr;

class TAO_Export CORBA_DynUnion_var
{
public:
  CORBA_DynUnion_var (void); // default constructor
  CORBA_DynUnion_var (CORBA_DynUnion_ptr);
  CORBA_DynUnion_var (const CORBA_DynUnion_var &); // copy constructor
  ~CORBA_DynUnion_var (void); // destructor

  CORBA_DynUnion_var &operator= (CORBA_DynUnion_ptr);
  CORBA_DynUnion_var &operator= (const CORBA_DynUnion_var &);
  CORBA_DynUnion_ptr operator-> (void) const;

  operator const CORBA_DynUnion_ptr &() const;
  operator CORBA_DynUnion_ptr &();
  // in, inout, out, _retn
  CORBA_DynUnion_ptr in (void) const;
  CORBA_DynUnion_ptr &inout (void);
  CORBA_DynUnion_ptr &out (void);
  CORBA_DynUnion_ptr _retn (void);
  CORBA_DynUnion_ptr ptr (void) const;

private:
  CORBA_DynUnion_ptr ptr_;
};

class TAO_Export CORBA_DynUnion_out
{
public:
  CORBA_DynUnion_out (CORBA_DynUnion_ptr &);
  CORBA_DynUnion_out (CORBA_DynUnion_var &);
  CORBA_DynUnion_out (const CORBA_DynUnion_out &);
  CORBA_DynUnion_out &operator= (const CORBA_DynUnion_out &);
  CORBA_DynUnion_out &operator= (const CORBA_DynUnion_var &);
  CORBA_DynUnion_out &operator= (CORBA_DynUnion_ptr);
  operator CORBA_DynUnion_ptr &();
  CORBA_DynUnion_ptr &ptr (void);
  CORBA_DynUnion_ptr operator-> (void);

private:
  CORBA_DynUnion_ptr &ptr_;
};

class TAO_Export CORBA_DynUnion: public virtual CORBA_DynAny
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynUnion_ptr _ptr_type;
    typedef CORBA_DynUnion_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynUnion_ptr _duplicate (CORBA_DynUnion_ptr obj);
  static CORBA_DynUnion_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynUnion_ptr _nil (void);

  virtual CORBA::Boolean set_as_default (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void set_as_default (
      CORBA::Boolean set_as_default,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr discriminator (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind discriminator_kind (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_DynAny_ptr member (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual char * member_name (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void member_name (
      const char * member_name,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::TCKind member_kind (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynUnion (void); // default constructor
  CORBA_DynUnion (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynUnion (void);
private:
  CORBA_DynUnion (const CORBA_DynUnion &);
  void operator= (const CORBA_DynUnion &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynUnion;

class _TAO_Unbounded_Sequence_CORBA_AnySeq : public TAO_Unbounded_Base_Sequence
{
public:
  // = Initialization and termination methods.

  _TAO_Unbounded_Sequence_CORBA_AnySeq (void) // Default constructor.
  {
  }

  _TAO_Unbounded_Sequence_CORBA_AnySeq (CORBA::ULong maximum) // Constructor using a maximum length value.
    : TAO_Unbounded_Base_Sequence (maximum, allocbuf (maximum))
  {
  }

  _TAO_Unbounded_Sequence_CORBA_AnySeq (CORBA::ULong maximum,
    CORBA::ULong length,
    CORBA::Any *data,
    CORBA::Boolean release = 0)
  : TAO_Unbounded_Base_Sequence (maximum, length, data, release)
  {
  }

  _TAO_Unbounded_Sequence_CORBA_AnySeq (const _TAO_Unbounded_Sequence_CORBA_AnySeq &rhs)
  // Copy constructor.
    : TAO_Unbounded_Base_Sequence (rhs)
  {
    CORBA::Any *tmp1 = allocbuf (this->maximum_);
    CORBA::Any * const tmp2 = ACE_reinterpret_cast (CORBA::Any * ACE_CAST_CONST, rhs.buffer_);

    for (CORBA::ULong i = 0; i < this->length_; ++i)
      tmp1[i] = tmp2[i];

    this->buffer_ = tmp1;
  }

  _TAO_Unbounded_Sequence_CORBA_AnySeq &operator= (const _TAO_Unbounded_Sequence_CORBA_AnySeq &rhs)
  // Assignment operator.
  {
    if (this == &rhs)
      return *this;

    if (this->release_)
    {
      if (this->maximum_ < rhs.maximum_)
      {
        // free the old buffer
        CORBA::Any *tmp = ACE_reinterpret_cast (CORBA::Any *, this->buffer_);
        freebuf (tmp);
        this->buffer_ = allocbuf (rhs.maximum_);
      }
    }
    else
      this->buffer_ = allocbuf (rhs.maximum_);

    TAO_Unbounded_Base_Sequence::operator= (rhs);

    CORBA::Any *tmp1 = ACE_reinterpret_cast (CORBA::Any *, this->buffer_);
    CORBA::Any * const tmp2 = ACE_reinterpret_cast (CORBA::Any * ACE_CAST_CONST, rhs.buffer_);

    for (CORBA::ULong i = 0; i < this->length_; ++i)
      tmp1[i] = tmp2[i];

    return *this;
  }

  ~_TAO_Unbounded_Sequence_CORBA_AnySeq (void) // Dtor.
  {
    this->_deallocate_buffer ();
  }

  // = Accessors.
  CORBA::Any &operator[] (CORBA::ULong i)
  // operator []
  {
    ACE_ASSERT (i < this->maximum_);
    CORBA::Any* tmp = ACE_reinterpret_cast(CORBA::Any*,this->buffer_);
    return tmp[i];
  }

  const CORBA::Any &operator[] (CORBA::ULong i) const
  // operator []
  {
    ACE_ASSERT (i < this->maximum_);
    CORBA::Any * const tmp = ACE_reinterpret_cast (CORBA::Any* ACE_CAST_CONST, this->buffer_);
    return tmp[i];
  }

  // = Static operations.
  static CORBA::Any *allocbuf (CORBA::ULong size)
  // Allocate storage for the sequence.
  {
    return new CORBA::Any[size];
  }

  static void freebuf (CORBA::Any *buffer)
  // Free the sequence.
  {
    delete [] buffer;
  }

  virtual void _allocate_buffer (CORBA::ULong length)
  {
    CORBA::Any* tmp = allocbuf (length);

    if (this->buffer_ != 0)
    {
      CORBA::Any *old = ACE_reinterpret_cast (CORBA::Any *,this->buffer_);

      for (CORBA::ULong i = 0; i < this->length_; ++i)
        tmp[i] = old[i];

      if (this->release_)
        freebuf (old);

    }
    this->buffer_ = tmp;
  }

  virtual void _deallocate_buffer (void)
  {
    if (this->buffer_ == 0 || this->release_ == 0)
      return;

    CORBA::Any *tmp = ACE_reinterpret_cast (CORBA::Any *,this->buffer_);

    freebuf (tmp);
    this->buffer_ = 0;
  }

  // Implement the TAO_Base_Sequence methods (see Sequence.h)

  CORBA::Any *get_buffer (CORBA::Boolean orphan = 0)
  {
    CORBA::Any *result = 0;
    if (orphan == 0)
    {
      // We retain ownership.
      if (this->buffer_ == 0)
      {
        result = allocbuf (this->length_);
        this->buffer_ = result;
      }
      else
      {
        result = ACE_reinterpret_cast (CORBA::Any*, this->buffer_);
      }
    }
    else // if (orphan == 1)
    {
      if (this->release_ != 0)
      {
        // We set the state back to default and relinquish
        // ownership.
        result = ACE_reinterpret_cast(CORBA::Any*,this->buffer_);
        this->maximum_ = 0;
        this->length_ = 0;
        this->buffer_ = 0;
        this->release_ = 0;
      }
    }
    return result;
  }

  const CORBA::Any *get_buffer (void) const
  {
    return ACE_reinterpret_cast(const CORBA::Any * ACE_CAST_CONST, this->buffer_);
  }

  void replace (CORBA::ULong max,
  CORBA::ULong length,
  CORBA::Any *data,
  CORBA::Boolean release)
  {
    this->maximum_ = max;
    this->length_ = length;
    if (this->buffer_ && this->release_ == 1)
    {
      CORBA::Any *tmp = ACE_reinterpret_cast(CORBA::Any*,this->buffer_);
      freebuf (tmp);
    }
    this->buffer_ = data;
    this->release_ = release;
  }

};

// *************************************************************
// class CORBA::AnySeq_var
// *************************************************************

class TAO_Export CORBA_AnySeq_var
{
public:
  CORBA_AnySeq_var (void); // default constructor
  CORBA_AnySeq_var (CORBA_AnySeq *);
  CORBA_AnySeq_var (const CORBA_AnySeq_var &); // copy constructor
  ~CORBA_AnySeq_var (void); // destructor

  CORBA_AnySeq_var &operator= (CORBA_AnySeq *);
  CORBA_AnySeq_var &operator= (const CORBA_AnySeq_var &);
  CORBA_AnySeq *operator-> (void);
  const CORBA_AnySeq *operator-> (void) const;

  operator const CORBA_AnySeq &() const;
  operator CORBA_AnySeq &();
  operator CORBA_AnySeq &() const;
  CORBA::Any &operator[] (CORBA::ULong slot);
  // in, inout, out, _retn
  const CORBA_AnySeq &in (void) const;
  CORBA_AnySeq &inout (void);
  CORBA_AnySeq *&out (void);
  CORBA_AnySeq *_retn (void);
  CORBA_AnySeq *ptr (void) const;

private:
  CORBA_AnySeq *ptr_;
};

class TAO_Export CORBA_AnySeq_out
{
public:
  CORBA_AnySeq_out (CORBA_AnySeq *&);
  CORBA_AnySeq_out (CORBA_AnySeq_var &);
  CORBA_AnySeq_out (const CORBA_AnySeq_out &);
  CORBA_AnySeq_out &operator= (const CORBA_AnySeq_out &);
  CORBA_AnySeq_out &operator= (CORBA_AnySeq *);
  operator CORBA_AnySeq *&();
  CORBA_AnySeq *&ptr (void);
  CORBA_AnySeq *operator-> (void);
  CORBA::Any &operator[] (CORBA::ULong slot);

private:
  CORBA_AnySeq *&ptr_;
  // assignment from T_var not allowed
  void operator= (const CORBA_AnySeq_var &);
};

// *************************************************************
// CORBA::AnySeq
// *************************************************************

class TAO_Export CORBA_AnySeq : public
#if defined (ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION) \
       || defined (ACE_HAS_TEMPLATE_INSTANTIATION_PRAGMA) \
       || !defined (ACE_HAS_TEMPLATE_SPECIALIZATION)
  _TAO_Unbounded_Sequence_CORBA_AnySeq
#else /* AHETI */
  TAO_Unbounded_Sequence<CORBA::Any>
#endif /* AHETI */
{
public:
  CORBA_AnySeq (void); // default ctor
  CORBA_AnySeq (CORBA::ULong max); // uses max size
  CORBA_AnySeq (
    CORBA::ULong max,
    CORBA::ULong length,
    CORBA::Any *buffer,
    CORBA::Boolean release=0
  );
  CORBA_AnySeq (const CORBA_AnySeq &); // copy ctor
  ~CORBA_AnySeq (void); // dtor

#if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
  typedef CORBA_AnySeq_ptr _ptr_type;
  typedef CORBA_AnySeq_var _var_type;
#endif /* __GNUC__ */

};

extern  CORBA::TypeCode_ptr  _tc_AnySeq;

class CORBA_DynSequence;
typedef CORBA_DynSequence *CORBA_DynSequence_ptr;

class TAO_Export CORBA_DynSequence_var
{
public:
  CORBA_DynSequence_var (void); // default constructor
  CORBA_DynSequence_var (CORBA_DynSequence_ptr);
  CORBA_DynSequence_var (const CORBA_DynSequence_var &); // copy constructor
  ~CORBA_DynSequence_var (void); // destructor

  CORBA_DynSequence_var &operator= (CORBA_DynSequence_ptr);
  CORBA_DynSequence_var &operator= (const CORBA_DynSequence_var &);
  CORBA_DynSequence_ptr operator-> (void) const;

  operator const CORBA_DynSequence_ptr &() const;
  operator CORBA_DynSequence_ptr &();
  // in, inout, out, _retn
  CORBA_DynSequence_ptr in (void) const;
  CORBA_DynSequence_ptr &inout (void);
  CORBA_DynSequence_ptr &out (void);
  CORBA_DynSequence_ptr _retn (void);
  CORBA_DynSequence_ptr ptr (void) const;

private:
  CORBA_DynSequence_ptr ptr_;
};

class TAO_Export CORBA_DynSequence_out
{
public:
  CORBA_DynSequence_out (CORBA_DynSequence_ptr &);
  CORBA_DynSequence_out (CORBA_DynSequence_var &);
  CORBA_DynSequence_out (const CORBA_DynSequence_out &);
  CORBA_DynSequence_out &operator= (const CORBA_DynSequence_out &);
  CORBA_DynSequence_out &operator= (const CORBA_DynSequence_var &);
  CORBA_DynSequence_out &operator= (CORBA_DynSequence_ptr);
  operator CORBA_DynSequence_ptr &();
  CORBA_DynSequence_ptr &ptr (void);
  CORBA_DynSequence_ptr operator-> (void);

private:
  CORBA_DynSequence_ptr &ptr_;
};

class TAO_Export CORBA_DynSequence: public virtual CORBA_DynAny
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynSequence_ptr _ptr_type;
    typedef CORBA_DynSequence_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynSequence_ptr _duplicate (CORBA_DynSequence_ptr obj);
  static CORBA_DynSequence_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynSequence_ptr _nil (void);

  virtual CORBA::ULong length (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void length (
      CORBA::ULong length,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynSequence (void); // default constructor
  CORBA_DynSequence (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynSequence (void);
private:
  CORBA_DynSequence (const CORBA_DynSequence &);
  void operator= (const CORBA_DynSequence &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynSequence;

class CORBA_DynArray;
typedef CORBA_DynArray *CORBA_DynArray_ptr;

class TAO_Export CORBA_DynArray_var
{
public:
  CORBA_DynArray_var (void); // default constructor
  CORBA_DynArray_var (CORBA_DynArray_ptr);
  CORBA_DynArray_var (const CORBA_DynArray_var &); // copy constructor
  ~CORBA_DynArray_var (void); // destructor

  CORBA_DynArray_var &operator= (CORBA_DynArray_ptr);
  CORBA_DynArray_var &operator= (const CORBA_DynArray_var &);
  CORBA_DynArray_ptr operator-> (void) const;

  operator const CORBA_DynArray_ptr &() const;
  operator CORBA_DynArray_ptr &();
  // in, inout, out, _retn
  CORBA_DynArray_ptr in (void) const;
  CORBA_DynArray_ptr &inout (void);
  CORBA_DynArray_ptr &out (void);
  CORBA_DynArray_ptr _retn (void);
  CORBA_DynArray_ptr ptr (void) const;

private:
  CORBA_DynArray_ptr ptr_;
};

class TAO_Export CORBA_DynArray_out
{
public:
  CORBA_DynArray_out (CORBA_DynArray_ptr &);
  CORBA_DynArray_out (CORBA_DynArray_var &);
  CORBA_DynArray_out (const CORBA_DynArray_out &);
  CORBA_DynArray_out &operator= (const CORBA_DynArray_out &);
  CORBA_DynArray_out &operator= (const CORBA_DynArray_var &);
  CORBA_DynArray_out &operator= (CORBA_DynArray_ptr);
  operator CORBA_DynArray_ptr &();
  CORBA_DynArray_ptr &ptr (void);
  CORBA_DynArray_ptr operator-> (void);

private:
  CORBA_DynArray_ptr &ptr_;
};

class TAO_Export CORBA_DynArray: public virtual CORBA_DynAny
{
public:
  #if !defined(__GNUC__) || __GNUC__ > 2 || __GNUC_MINOR__ >= 8
    typedef CORBA_DynArray_ptr _ptr_type;
    typedef CORBA_DynArray_var _var_type;
  #endif /* __GNUC__ */

  // the static operations
  static CORBA_DynArray_ptr _duplicate (CORBA_DynArray_ptr obj);
  static CORBA_DynArray_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  static CORBA_DynArray_ptr _nil (void);

  virtual CORBA_AnySeq * get_elements (
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual void set_elements (
      const CORBA_AnySeq & value,
      CORBA::Environment &ACE_TRY_ENVironment =
        CORBA::Environment::default_environment ()
     );
  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id,
      CORBA::Environment &ACE_TRY_ENV =
        CORBA::Environment::default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;
protected:
  CORBA_DynArray (void); // default constructor
  CORBA_DynArray (TAO_Stub *objref,
      TAO_ServantBase *_tao_servant = 0,
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~CORBA_DynArray (void);
private:
  CORBA_DynArray (const CORBA_DynArray &);
  void operator= (const CORBA_DynArray &);
};

extern  CORBA::TypeCode_ptr  _tc_CORBA_DynArray;

#if defined (__ACE_INLINE__)
#include "tao/DynAnyC.i"
#endif /* defined INLINE */

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
#pragma warning(pop)
#endif /* _MSC_VER */

#endif /* TAO_HAS_MINIMUM_CORBA */

#endif /* if !defined */
