/* ----------------------------------------------------------------------------
    The configuration file for the MRPT C++ Library
 
 JLBC
 ---------------------------------------------------------------------------- */

#ifndef MRPT_CONFIG_H
#define MRPT_CONFIG_H
#include <MRPT/UTILS/MRPT_version.h>

/** If defined, security checks (ASSERT_'s) will be performed in many MRPT classes even if "_DEBUG" is not declared, which is the default behavior.
  */
#define MRPT_ALWAYS_CHECKS_DEBUG 0

/** Includes the OpenCV library, required for image manipulation.
  * \sa CImageGrabber_OpenCV
  */
#define MRPT_HAS_OPENCV  1

/** Includes OpenGL & GLUT libraries, required for CDisplayWindows3D to work.
  */
#define MRPT_HAS_OPENGL_GLUT 1

/** Define for including Bumblebee interface through the vendor's proprietary API, which enables the definition of some classes in the MRVL namespace.
  * \sa CStereoGrabber_Bumblebee
  */
#define MRPT_HAS_BUMBLEBEE 0

/** The file ftdi.h exists (Linux only)
  */
#define MRPT_HAS_FTDI 1

#if defined(_WIN32_) || defined(WIN32) || defined(WINDOWS)
    /** Defined if we are in a Windows OS
      */
    #define MRPT_OS_WINDOWS
#else
    /** Defined if we are in a Linux OS
      */
    #define MRPT_OS_LINUX
#endif


#if defined(_MSC_VER) && (_MSC_VER>=1300)
	/** Define this symbol if the target processor supports the SSE machine instructions set
	*/
	#define MRPT_HAS_SSE
#endif

// -------------------------------
//			Some checks:
// -------------------------------
#if defined(MRPT_OS_WINDOWS) && defined(MRPT_OS_LINUX)
#error You can't define both MRPT_OS_LINUX and MRPT_OS_WINDOWS!
#endif
#if !defined(MRPT_OS_WINDOWS) && !defined(MRPT_OS_LINUX)
#error You must define either MRPT_OS_LINUX or MRPT_OS_WINDOWS!
#endif


#endif

