/*---------------------------------------------------------------
	FILE: utils.h
	USE: Includes all definitions for "UTILS" library

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef UTILS_H
#define UTILS_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/MRPT_OS.h>

/** Into this namespace are various math and utilities classes and definitions.
 *    See <A HREF="main.html#_util">main page</A> for a description of the contents of this library
 */
namespace UTILS
{
	/** You must call UTILS::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  */
	void registerAllClasses();
}

// Math classes:
#include <MRPT/UTILS/CMatrixTemplate.h>
#include <MRPT/UTILS/CMatrixTemplateNumeric.h>
#include <MRPT/UTILS/CMatrixTemplateObjects.h>
#include <MRPT/UTILS/CMatrix.h>
#include <MRPT/UTILS/CMatrixD.h>

#include <MRPT/UTILS/CVectorTemplate.h>
#include <MRPT/UTILS/EKF.h>
#include <MRPT/UTILS/IEKF.h>
#include <MRPT/UTILS/UKF.h>
#include <MRPT/UTILS/HybridKF.h>
#include <MRPT/UTILS/CMonoSlamMotionModel.h>
#include <MRPT/UTILS/CQuaternion.h>
#include <MRPT/UTILS/CFeature.h>

#include <MRPT/UTILS/CDebugOutputCapable.h>
#include <MRPT/UTILS/RandomGenerator.h>
#include <MRPT/UTILS/CHistogram.h>
#include <MRPT/UTILS/CGraphPartitioner.h>
#include <MRPT/UTILS/CParticleFilter.h>
#include <MRPT/UTILS/CRejectionSamplingCapable.h>
#include <MRPT/UTILS/CPolygon.h>
#include <MRPT/UTILS/CProbabilityParticle.h>
#include <MRPT/UTILS/CStringList.h>


// CStream related classes:
#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/UTILS/CStream.h>
#include <MRPT/UTILS/CMemoryStream.h>
#include <MRPT/UTILS/CFileStream.h>

// TCP sockets:
#include <MRPT/UTILS/CServerTCPSocket.h>
#include <MRPT/UTILS/CClientTCPSocket.h>

// Others:
#include <MRPT/UTILS/SystemUtils.h>
#include <MRPT/UTILS/CDisplayWindow.h>
#include <MRPT/UTILS/CDisplayWindow3D.h>

#include <MRPT/UTILS/GEO.h>
#include <MRPT/UTILS/MRPT_math.h>
#include <MRPT/UTILS/SYNCH.h>

#include <MRPT/UTILS/ZipCompression.h>

#include <MRPT/UTILS/CEnhancedMetaFile.h>
#include <MRPT/UTILS/CMRPTCanvas.h>
#include <MRPT/UTILS/CMRPTImage.h>
#include <MRPT/UTILS/CMRPTImageFloat.h>
#include <MRPT/UTILS/CDirectoryExplorer.h>
#include <MRPT/UTILS/CTicTac.h>
#include <MRPT/UTILS/CJoystick.h>
#include <MRPT/UTILS/CSimpleDatabase.h>
#include <MRPT/UTILS/CPropertiesValuesList.h>
#include <MRPT/UTILS/CTypeSelector.h>
#include <MRPT/UTILS/CHillClimbing.h>
#include <MRPT/UTILS/CLoadableOptions.h>
#include <MRPT/UTILS/CDynamicGrid.h>
#include <MRPT/UTILS/CMRPTMessage.h>
#include <MRPT/UTILS/COpenGLScene.h>

#include <MRPT/UTILS/CConfigFile.h>
#include <MRPT/UTILS/CConfigFileMemory.h>

#endif

