/*---------------------------------------------------------------
	FILE: CPropertiesValuesList.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CPropertiesValuesList_H
#define  CPropertiesValuesList_H

#include <MRPT/UTILS/CSerializable.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class represents a std::string derived class which is also CSerializable
	 * \sa CSerializable
	 */
	class CPropertiesValuesList : public CSerializable
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CPropertiesValuesList )
	protected:
		struct TPropertyValuePair
		{
			std::string		name;
			CSerializable	*value;
		};
		/** The properties list: a map between strings and objects
		  */
		std::vector<TPropertyValuePair>	properties;

	public:
		/** Default constructor
		  */
		CPropertiesValuesList();

		/** Destructor
		  */
		virtual ~CPropertiesValuesList();

		/** Clears the list.
		  */
		void  clear();

		/** Returns the value of the property (case insensitive), or NULL if it does not exist.
		  */
		CSerializable*  get(const char *propertyName) const;

		/** Sets/change the value of the property (case insensitive), making a copy of the object (or setting it to NULL if it is the passed value)
		  */
		void  set(const char *propertyName,CSerializable*obj);

		/** Returns the number of properties in the list
		  */
		size_t  size() const;

		/** Returns the name of all properties in the list
		  */
		std::vector<std::string>  getPropertyNames() const;

	}; // End of class def.

} // End of namespace

#endif
