/*---------------------------------------------------------------
	FILE: CJoystick.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CJOYSTICK_H
#define  CJOYSTICK_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/config.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class can be used to query information and position
	 *   about Joysticks in the computer.
	 *
	 * This class requires linking agains "winmm.lib"
	 */
	class CJoystick
	{
	private:
		/** The axis limits:
		 */
		int x_min,x_max,y_min,y_max,z_min,z_max;

	public:
		/** Constructor
		 */
		CJoystick();


		/** Returns the number of Joysticks in the computer.
		 */
		static int  getJoysticksCount();

		/** Gets joystick information.
		 *
		 * \param nJoy Can be 1 or 2, selecting the joystick to be read.Default joystick is "1".
		 * \param x The x axis position, range [-1,1]
		 * \param y The y axis position, range [-1,1]
		 * \param z The z axis position, range [-1,1]
		 * \param buttons Each element will hold true if buttons are pressed.Calling must provide a pointer to an existent array of 4 bools
		 * \param raw_x_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 * \param raw_y_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 * \param raw_z_pos If it is desired the raw integer measurement from JoyStick, set this pointer to a desired placeholder.
		 *
		 * \return Returns true if successfull, false on error, for example, if joystick is not present.
		 *
		 * \sa setLimits
		 */
		bool  getJoystickPosition( int nJoy , float &x,float &y,float &z, bool buttons[4],int *raw_x_pos=NULL,int	*raw_y_pos=NULL, int *raw_z_pos=NULL );

		/** Set the axis limit values, for computing a [-1,1] position index easily.
		 *   It seems that these values must been calibrated for each joystick model.
		 *
		 * \sa getJoystickPosition
		 */
		void  setLimits( int x_min = 0,int x_max = 0xFFFF, int y_min=0,int y_max = 0xFFFF,int z_min=0,int z_max = 0xFFFF );

	}; // End of class def.

} // End of namespace

#endif
