/*---------------------------------------------------------------
	FILE: CHistogram.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CHISTOGRAM_H
#define  CHISTOGRAM_H

#include <MRPT/UTILS/utils_defs.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class provides an easy way of computing histograms for unidimensional real valued variables.
	 *   How to use it:
	\code
	CHistogram		hist(0,100,10);
	hist.add(86);
	hist.add(7);
	hist.add(45);

	std::cout << hist.getBinCount(0) << std::endl;		// Result: "1"
	std::cout << hist.getBinRatio(0) << std::endl;		// Result: "0.33"
	\endcode
	 */
	class CHistogram
	{
	private:
		/** Private members:
		 */
		double	min,max;

		/** The bins counter
		 */
		std::vector<int>	bins;

		/** The total elements count
		 */
		int					count;

	public:
		/** Constructor
		 * \exception std::exception On nBins<=0 or max<=min
		 */
		CHistogram(double min, double max, int nBins);

		/** Clear the histogram:
		 */
		void	clear();

		/**	Add an element to the histogram. If element is out [min,max] it is ignored.
		 */
		void	add(double x);

		/** Retuns the elements count into the selected bin index, where first one is 0.
		 * \exception std::exception On invalid index
		 */
		int		getBinCount(int index);

		/** Retuns the ratio in [0,1] range for the selected bin index, where first one is 0.
		 *  It returns 0 if no elements have been added.
		 * \exception std::exception On invalid index.
		 */
		double	getBinRatio(int index);


	}; // End of class def.

} // End of namespace

#endif
