/*---------------------------------------------------------------
	FILE: MRVL.h
	USE: See doxygen doc.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
/**  This is the main "include file" for classes into the MRML namespace. This file
 *	   includes all the other ones, so user applications must include just this one
 *     and link against the "MRPT.LIB" file.
 */
#ifndef MRVL_H
#define MRVL_H

/**   See <A HREF="main.html#_mrvl">main page</A> for a description of the contents of this namespace
 */
namespace MRVL
{
	/** You must call MRVL::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  */
	void registerAllClasses();
}

// Classes into MRVL
// --------------------------------------------
#include <MRPT/MRVL/CStereoGrabber_Bumblebee.h>
#include <MRPT/MRVL/CImageGrabber_OpenCV.h>
#include <MRPT/MRVL/VisionUtils.h>
#include <MRPT/MRVL/CStereoImagesTo3D.h>
#include <MRPT/MRVL/CGaussianConvolutionKernel.h>
#include <MRPT/MRVL/CImageConvolution.h>
#include <MRPT/MRVL/CHarrisFeatureDetector.h>
#include <MRPT/MRVL/CCamModel.h>
#include <MRPT/MRVL/CKanadeLucasTomasi.h>
#include <MRPT/MRVL/CVisualOdometryStereo.h>
#include <MRPT/MRVL/CStereoServerBumblebee.h>
#include <MRPT/MRVL/CFeatureExtraction.h>
#include <MRPT/MRVL/CDescriptorComputation.h>

#endif
