/*---------------------------------------------------------------
	FILE: CStereoImagesTo3D.cpp
	USE: See doxygen doc.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CStereoImagesTo3D_H
#define CStereoImagesTo3D_H

#include <MRPT/MRML/CObservationVisualLandmarks.h>
#include <MRPT/MRML/CObservationStereoImages.h>

namespace MRVL
{
	/** A class for processing a pair of stereo images and generateing a disparity image and/or a 3D landmarks map.
	  */
	class CStereoImagesTo3D
	{
	protected:

	public:
		/** Constructor:
		*/
		CStereoImagesTo3D( );

		/** Destructor
		*/
		virtual ~CStereoImagesTo3D( );

		/** Process a pair of stereo images and generates a disparity image and/or a 3D landmarks map.
		 * \param in_stereoImages	The pair of images. REMEMBER that images have to be undistorted previously to this call!
		*/
		void  stereo( MRML::CObservationStereoImages		&in_stereoImages,
								MRML::CObservationVisualLandmarks	&out_landmarks );


	};	// End of class

} // End of NS


#endif
