/*---------------------------------------------------------------
	FILE: CHierarchicalMap.h
	USE: See doxygen doc

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CHierarchicalMap_H
#define CHierarchicalMap_H

#include <MRPT/MRML/CHMapNode.h>
#include <MRPT/MRML/CHMapArc.h>
#include <MRPT/MRML/CHierarchicalMapPartition.h>
#include <MRPT/MRML/CSensFrameProbSequence.h>
#include <MRPT/MRML/CMultiMetricMap.h>
#include <MRPT/UTILS/CSerializable.h>


namespace MRML
{
	/** The most high level class for storing maps in a hierarchical graph-based model.
	 *
	 * \sa CSensorialFrame
	 */
	class CHierarchicalMap : public CSerializable, public CHierarchicalMapPartition
	{
		friend class CHMapArc;
		friend class CHMapNode;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CHierarchicalMap )
	protected:
		/** Event handler to be called just after a node has being created: it will be added to the internal list.
		  */
		 void  onNodeAddition(CHMapNode *node);

		/** Event handler to be called just after an arc has being created: it will be added to the internal list.
		  */
		 void  onArcAddition(CHMapArc *arc);

		/** Event handler to be called just before a node is being destroyed: it will be removed from the internal list.
		  */
		 void  onNodeDestruction(CHMapNode *node);

		/** Event handler to be called just before an arc is being destroyed: it will be removed from the internal list.
		  */
		 void  onArcDestruction(CHMapArc *arc);

	public:
		 /** Default constructor
		  */
		 CHierarchicalMap();

		 /** Destructor
		  */
		 virtual ~CHierarchicalMap();

		 /** Erase all the contents of map (It delete all nodes/arcs objects)
		   */
		 void  clear();

		 /** Insert a metric map in the form of a "CSensFrameProbSequence" object:
		   *  It creates nodes in the ground level for each SensorialFrame, a high-level
		   *   node representing the metric map which is returned by the method.
		   *  No arcs are created between the SFs, but between them and the high-level node,
		   *   with a pose PDF annotation with the one provided in the "CSensFrameProbSequence" object.
		   * \sa CSensFrameProbSequence
		   */
		 CHMapNode* 	insertMetricMap(
			 CSensFrameProbSequence			&SFs,
			 TSetOfMetricMapInitializers	*mapsInitializers );


	}; // End of class def.

} // End of namespace

#endif
