/*---------------------------------------------------------------
	FILE: CBoardENoses.h

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/

#ifndef CBoardENoses_H
#define CBoardENoses_H

#include <MRPT/HWDRIVERS/CInterfaceFTDIMessages.h>


namespace HWDRIVERS
{
	/** A class for interfacing an e-Noses via a FTDI USB link.
	  *  Implemented for the board v1.0 designed by 2007 @ ISA (University of Malaga).
 	  */
	class CBoardENoses : public HWDRIVERS::CInterfaceFTDIMessages
	{
	protected:
		/** A copy of the device serial number (to open the USB FTDI chip)
		  */
		std::string		m_usbSerialNumber;

		/** Tries to connect to the USB device (if disconnected).
		  * \return True on connection OK, false on error.
		  */
		bool	checkConnectionAndConnect();

	public:
		/** Constructor
		  * \param serialNumberUSBdevice The serial number (text) of the device to open.
		  *  The constructor will try to open the device. You can check if it failed calling "isOpen()".
		  */
		CBoardENoses( const std::string & serialNumberUSBdevice );

		/** Destructor
		  */
		virtual ~CBoardENoses();

		/** Query the firmware version on the device (can be used to test communications).
		  * \return true on success, false on communications errors or device not found.
		  */
		bool	queryFirmwareVersion( std::string &out_firmwareVersion );

	}; // end of class

} // end of namespace


#endif


