/*---------------------------------------------------------------
	FILE: CPolygon.h
	USE: Declares a class for polygon manipulation, including
	       testing for a 2D point inside it.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPOLYGON_H
#define CPOLYGON_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CSerializable.h>

namespace UTILS
{
	/** A simple 2D polygon class, mainly for checking points falling inside it.
	 */
	class CPolygon : public CSerializable
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CPolygon )

	private:
		/** The placeholders for vertexs
		 */
		std::vector<float>	vx,vy;

		/** The "central" point coordinates (laser sensor location if applicable)
		 */
		float				cx,cy;

		/** Automatically maintained max/min coordinates of polygon.
		 */
		float			min_x,max_x,min_y,max_y;

		/* Return "true" if P is on the left side of P0-P1:
		 */
		bool	isLeft( float P0x,float P0y,float P1x,float P1y,float Px,float Py  );

	public:
		/** Constructor:
		 */
		CPolygon(float cx = 0,float  cy = 0);

		/** Add a new vertex to polygon:
		 */
		void  AddVertex(float x,float y);

		/** Methods for accessing the vertexs:
		 */
		float  GetVertex_x(int i) { return vx[i]; }
		float  GetVertex_y(int i) { return vy[i]; }

		/** Returns the vertices count in the polygon:
		  */
		int   verticesCount() { return (int)vx.size(); }

		/** Set all vertices at once, not to be used normally.
		  */
		void  setAllVertices( int nVertices, float *xs, float *ys );

		/** Clear the polygon, erasing all vertexs.
		 */
		void   Clear() { vx.clear(); vy.clear(); }

		/**	Check if a point is inside the polygon:
		 */
		bool  PointIntoPolygon(float x,float y);

		/** Computed the angle between the viewing angle and the
		 *  closest edge in the polygon to the given point.
		 */
		float ComputeTangentAngNearPoint(float x,float y,float view_phi, float min_dist);
	};

} // End of namespace

#endif
