/*---------------------------------------------------------------
	FILE: CMRPTMessage.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CMRPTMessage_H
#define  CMRPTMessage_H

#include <MRPT/UTILS/utils_defs.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	class	CSerializable;
	struct	TRuntimeClassId;

	/** A class that contain generic messages, that can be sent and received from a "CClientTCPSocket" object.
	  *  A message consists of a "header" (or type), and a "body" (or content).
	  *  Apart from arbitrary data, specific methods are provided for easing the serialization of MRPT's "CSerializable" objects.
	  *  This class is also used for passing data to hardware interfaces (see )
	  * \sa CClientTCPSocket
	  */
	class CMRPTMessage
	{
	public:
		/** An identifier of the message type.
		  */
		uint32_t						type;

		/** The contents of the message (memory is automatically handled by the std::vector object)
		  */
		std::vector<unsigned char>	content;

		/** A method for serializing a MRPT's object into the content.
		  *  Any modification to data in "content" after this will corrupt the object serialization.
		  *  Member "type" is unmodified in this method.
		  */
		void  serializeObject( CSerializable *obj );

		/** A method that parse the data in the message into an existing object.
		  *  Note that the class of the object must be known and must match the one of the serialized object.
		  * \except std::exception On corrupt data, unknown serialized objects, unknown serialized object version, non-matching classes,...
		  */
		void  deserializeIntoExistingObject( CSerializable *obj );

		/** A method that parse the data in the message into a new object of (a priori) unknown class.
		  *  The pointer will contain on return a copy of the reconstructed object. Deleting this object when
		  *   no longer required is the responsability of the user. Note that previous contents of the pointer
		  *   will be ignored (it should be NULL).
		  * \except std::exception On corrupt data, unknown serialized objects, unknown serialized object version,...
		  */
		void  deserializeIntoNewObject( CSerializable *&obj );

		/** Sets the contents of the message from a string
		  */
		void  setContentFromString( const std::string &str );

		/** Gets the contents of the message as a string
		  */
		void  getContentAsString( std::string &str );

	}; // End of class

} // End of namespace

#endif
