/*---------------------------------------------------------------
	FILE: CSensFrameProbSequence.h
	USE: See below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CSensFrameProbSequence_H
#define CSensFrameProbSequence_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/MRML/CSensorialFrame.h>
#include <MRPT/MRML/CPosePDF.h>

namespace MRML
{
	/** This class stores a sequence of <Probabilistic Pose,SensorialFrame> pairs, thus
	 *     a "metric map" can be totally determined with this information. The pose of the
	 *	   sensorial frame is not deterministic, but described by some PDF.
	 *
	 * \sa CSensorialFrame, CPosePDF
	 */
	class CSensFrameProbSequence : public CSerializable
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CSensFrameProbSequence )

	public:
		/** Constructor
		  */
		CSensFrameProbSequence();

		/** Copy constructor
		  */
		void operator = ( const CSensFrameProbSequence& o);

		/**  Destructor:
		  */
		virtual ~CSensFrameProbSequence();

		/** Returns the pairs count.
		  */
		unsigned int  size();

		/** Access to the i'th pair, first one is index '0'. NOTE: This method
		  *  returns pointers to the objects inside the list, nor a copy of them,
		  *  so <b>do neither modify them nor delete them</b>.
		  * NOTE: You can pass a NULL pointer if you dont need one of the two variables to be returned.
		  * \exception std::exception On index out of bounds.
		  */
		void  get(size_t index, CPosePDF *&out_posePDF, CSensorialFrame *&out_SF );

		/** Changes the i'th pair, first one is index '0'.
		  *  The referenced object is COPIED, so you can freely destroy the object passed as parameter after calling this.
		  *  If one of the pointers is NULL, the corresponding contents of the current i'th pair is not modified (i.e. if you want just to modify one of the values).
		  * \exception std::exception On index out of bounds.
		  * \sa insert, get, remove
		  */
		void  set(size_t index, CPosePDF *in_posePDF, CSensorialFrame *in_SF );

		/** Deletes the i'th pair, first one is index '0'.
		  * \exception std::exception On index out of bounds.
		  * \sa insert, get, set
		  */
		void  remove(size_t index);

		/** Add a new pair to the sequence. The objects are copied, so original ones can be free if desired
		  *  after insertion.
		  */
		void  insert( CPosePDF *in_posePDF, CSensorialFrame *in_SF );

		/** Remove all stored pairs.
		  * \sa remove
		  */
		void  clear();



	private:

		struct TPosePDFSensFramePair
		{
			CPosePDF				*posePDF;
			CSensorialFrame			*observations;
		};

		/** The stored information:
		  */
		std::deque<TPosePDFSensFramePair>		posesObsPairs;

	}; // End of class def.


} // End of namespace

#endif
