/*---------------------------------------------------------------
	FILE: CPose.h
	USE: See above.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPOSE_H
#define CPOSE_H

#include <MRPT/MRML/CPoseOrPoint.h>

namespace MRML
{

	/** A virtual base class to represent a pose in 2D or 3D.
	 *
	 * \sa CPoseOrPoint,CPose, CPoint
	 */
	class CPose : public CPoseOrPoint
	{
		// This must be added to any CSerializable derived class:
		DEFINE_VIRTUAL_SERIALIZABLE( CPose )

	public:
		/** The operator \f$ a \oplus b \f$ is the pose compounding operator.
		   */
		 CPose3D  operator + (const CPose3D& b) const;

		/** The operator \f$ a \oplus b \f$ is the pose compounding operator.
		   */
		 CPoint3D  operator + (const CPoint3D& b) const;



		 /** The operator \f$ a \ominus b \f$ is the pose inverse compounding operator.
		   */
		 CPose3D  operator - (const CPose3D& b) const;

		 /** The operator \f$ a \ominus b \f$ is the pose inverse compounding operator.
		   */
		 CPoint3D  operator - (const CPoint3D& b) const;


	}; // End of class def.

} // End of namespace

#endif
