/*---------------------------------------------------------------
	FILE: CPointPDF.h
	USE: See above.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPointPDF_H
#define CPointPDF_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/MRML/CPoint3D.h>

namespace MRML
{
	/** Declares a class that represents a Probability Distribution
	 *    function (PDF) of a 3D point (x,y,z).
	 *   This class is just the base class for unifying many diferent
	 *    ways this PDF can be implemented.
	 *
	 *  For convenience, a pose composition is also defined for any
	 *    PDF derived class, changeCoordinatesReference, in the form of a method rather than an operator.
     *
	 *  For a similar class for 6D poses (a 3D point with attitude), see CPose3DPDF
	 *
	 * \sa CPoint3D
	 */
	class CPointPDF : public CSerializable
	{
		DEFINE_VIRTUAL_SERIALIZABLE( CPointPDF )

	 public:
		 /** Returns an estimate of the point, (the mean, or mathematical expectation of the PDF)
		  */
		virtual CPoint3D  getEstimatedPoint() const = 0 ;

		 /** Returns an estimate of the point covariance matrix (3x3 cov.matrix for x,y,z variables)
		  */
		virtual CMatrix  getEstimatedCovariance() const = 0 ;

		/** Copy operator, translating if necesary (for example, between particles and gaussian representations)
		  */
		virtual void  copyFrom(const CPointPDF &o) = 0;

		/** Save PDF's particles to a text file. See derived classes for more information about the format of generated files.
		 */
		virtual void  saveToTextFile(char *file) const = 0;

		/** This can be used to convert a PDF from local coordinates to global, providing the point (newReferenceBase) from which
		  *   "to project" the current pdf. Result PDF substituted the currently stored one in the object.
		  */
		virtual void  changeCoordinatesReference( const CPose3D &newReferenceBase ) = 0;


	}; // End of class def.

} // End of namespace

#endif
