/*---------------------------------------------------------------
	FILE: CPoint2D.h
	USE: Declares a class for storing a 2D point

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPOINT2D_H
#define CPOINT2D_H

#include <MRPT/UTILS/CSerializable.h>
#include <MRPT/MRML/CPoint.h>

namespace MRML
{
	/** A class used to store a 2D point.
			<br>For a complete description of Points/Poses, see MRML::CPoseOrPoint<br>

<div align=center>

<table class=MsoTableGrid border=1 cellspacing=0 cellpadding=0
 style='border-collapse:collapse;border:none'>
 <tr>
  <td width=576 colspan=2 style='width:432.2pt;border:solid windowtext 1.0pt;
  background:#E6E6E6;padding:0cm 5.4pt 0cm 5.4pt'>
  <p   align=center style='text-align:center'>MRML::CPoint2D</p>
  </td>
 </tr>
 <tr>
  <td width=288 style='width:216.1pt;border:solid windowtext 1.0pt;border-top:
  none;padding:0cm 5.4pt 0cm 5.4pt'>
  <p   align=center style='text-align:center'>Homogeneous
  transfomation matrix</p>
  </td>
  <td width=288 style='width:216.1pt;border-top:none;border-left:none;
  border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;
  padding:0cm 5.4pt 0cm 5.4pt'>
  <p   align=center style='text-align:center'>Spatial
  representation</p>
  </td>
 </tr>
 <tr style='height:108.3pt'>
  <td width=288 style='width:216.1pt;border:solid windowtext 1.0pt;border-top:
  none;padding:0cm 5.4pt 0cm 5.4pt;height:108.3pt'>
  <div align=center>
  <table  Table border=0 cellspacing=0 cellpadding=0 width="46%"
   style='width:46.84%;border-collapse:collapse'>
   <tr style='height:16.5pt'>
    <td width=32 style='width:24.0pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>1</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>x</p>
    </td>
   </tr>
   <tr style='height:16.5pt'>
    <td width=32 style='width:24.0pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>1</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>y</p>
    </td>
   </tr>
   <tr style='height:16.5pt'>
    <td width=32 style='width:24.0pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>1</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
   </tr>
   <tr style='height:16.5pt'>
    <td width=32 style='width:24.0pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>0</p>
    </td>
    <td width=32 style='width:24.05pt;padding:0cm 5.4pt 0cm 5.4pt;height:16.5pt'>
    <p   align=center style='text-align:center'>1</p>
    </td>
   </tr>
  </table>
  </div>
  <p   align=center style='text-align:center'></p>
  </td>
  <td width=288 style='width:216.1pt;border-top:none;border-left:none;
  border-bottom:solid windowtext 1.0pt;border-right:solid windowtext 1.0pt;
  padding:0cm 5.4pt 0cm 5.4pt;height:108.3pt'>
  <p   align=center style='text-align:center'><img src="CPoint2D.gif"></p>
  </td>
 </tr>
</table>

</div>
	 * \sa CPoseOrPoint,CPose, CPoint
	 */
	class CPoint2D : public CPoint
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CPoint2D )

	 public:
		 /** Constructor for initializing point coordinates.
		  */
		 CPoint2D(float x=0,float y=0);

		 /** The operator D="this"-b is the pose inverse compounding operator,
		   *   the resulting points "D" fulfils: "this" = b + D, so that: b == a + (b-a)
		   */
		 CPoint2D  operator - (const CPose2D& b) const;

		 /** Returns the corresponding 4x4 homogeneous
		   *  transformation matrix for the point(translation),
		   *  or pose (translation+orientation).
		   * \sa getInverseHomogeneousMatrix
		   */
		 UTILS::CMatrix  getHomogeneousMatrix() const;

		 /** Returns the corresponding 4x4 homogeneous
		   *  transformation matrix for the point(translation),
		   *  or pose (translation+orientation).
		   * \sa getInverseHomogeneousMatrix
		   */
		 void  getHomogeneousMatrix(const UTILS::CMatrix *& ptrHM ) const;

	}; // End of class def.

	/**  Textual output stream function.
	 */
	std::ostream& operator << (std::ostream& o, const CPoint2D& p);

} // End of namespace

#endif
