/*---------------------------------------------------------------
	FILE: CPathPlanningCircularRobot.h
	USE: See DOXYGEN description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CPathPlanningCircularRobot_H
#define CPathPlanningCircularRobot_H

#include <MRPT/MRML/CPathPlanningMethod.h>


namespace MRML
{
	/** An implementation of CPathPlanningMethod
     *
	 * \sa CPathPlanningMethod
	 */
	class CPathPlanningCircularRobot : public CPathPlanningMethod
	{
	public:
		/** Default constructor
		  */
		CPathPlanningCircularRobot();

		/** Destructor
		  */
        virtual ~CPathPlanningCircularRobot()
		{
		}

		/** The aproximate robot radius used in the planification. Default is 0.35m
		  */
		float	robotRadius;

		/** This method compute the optimal path for a circular robot, in the given
		  *   occupancy grid map, from the origin location to a target point.
		  * The options and additional parameters to this method can be set with
		  *   member configuration variables.
		  *
		  * \param theMap	[IN] The occupancy gridmap used to the planning.
		  * \param origin	[IN] The starting pose of the robot (given as a CPose2D, CPoint2D,...), in coordinates of "map".
		  * \param target	[IN] The desired target pose for the robot (given as a CPose2D, CPoint2D,...), in coordinates of "map".
		  * \param path		[OUT] The found path, in global coordinates relative to "map".
		  * \param notFount	[OUT] Will be true if no path has been found.
		  * \param maxSearchPathLength [IN] The maximum path length to search for, in meters (-1 = no limit)
		  *
		  * \sa robotRadius
		  *
		  * \exception std::exception On any error
		  */
		void  computePath(
				COccupancyGridMap2D			*theMap,
				CPoseOrPoint				*origin,
				CPoseOrPoint				*target,
				std::deque<MRML::CPoint2D>	&path,
				bool						&notFound,
				float						maxSearchPathLength = -1
				);

	};


} // End of namespace

#endif
