/*---------------------------------------------------------------
	FILE: CInterfaceFTDIMessages.h

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/

#ifndef CInterfaceFTDIMessages_H
#define CInterfaceFTDIMessages_H

#include <MRPT/HWDRIVERS/CInterfaceFTDI.h>
#include <MRPT/UTILS/CMRPTMessage.h>

namespace HWDRIVERS
{

	/** An implementation of message passing over a FTDI USB link.
	 *  	The limit for the body size is 255 bytes. The frame format is an array of bytes, in this order:
	  \code
		<START_FLAG> <HEADER> <LENGTH> <BODY> <END_FLAG>

			<START_FLAG> 	= 0x69
			<HEADER> 		= A header byte
			<LENGHT>		= Number of bytes of BODY
			<BODY>			= N x bytes
			<END_FLAG>		= 0X96
				 Total length 	= 	<LENGTH> + 4
	  \endcode
	 * \sa CInterfaceFTDI
	 */
	class CInterfaceFTDIMessages : public HWDRIVERS::CInterfaceFTDI
	{
	public:
		/** Constructor
		  */
		CInterfaceFTDIMessages();

		/** Destructor
		  */
		virtual ~CInterfaceFTDIMessages();

		/** Send a message to the device.
		  *  Note that only the low byte from the "type" field will be used.
		  * \exception std::exception On communication errors
		  */
		void  sendMessage( const UTILS::CMRPTMessage &msg);

		/** Tries to receive a message from the device.
		  * \exception std::exception On communication errors
		  * \returns True if successful, false if there is no new data from the device (but communications seem to work fine)
		  */
		bool  receiveMessage( UTILS::CMRPTMessage &msg );

	}; // end of class

} // end of namespace


#endif


