/*---------------------------------------------------------------
	FILE: CTypeSelector.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CTypeSelector_H
#define  CTypeSelector_H

#include <MRPT/UTILS/CSerializable.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class represents a std::string derived class which is also CSerializable
	 * \sa CSerializable
	 */
	class CTypeSelector : public CSerializable
	{
		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CTypeSelector )
	protected:
		/** The possibilities
		  */
		std::vector<std::string>	possibleTypes;

		/** The selected one:
		  */
		unsigned int				selection;

	public:
		/** Default constructor.
		  * \param posibilitiesList The list of options, as a comma-separated-string, for example: "type 1,other type 2,type_3"
		  * \param defaultType Default type value
		  */
		CTypeSelector(std::string posibilitiesList = "", std::string defaultType = "");

		/** Destructor
		  */
		virtual ~CTypeSelector();

		/** Returns the set of posibilities in the "type" represented by this class.
		  */
		void  getTypePosibilities( std::vector<std::string> &outPosibilities)const;


		/** Gets the currently selected type, from the set of posibilities.
		  * \sa setType,getTypePosibilities
		  * \exception std::exception If currently there is not a valid selection.
		  */
		std::string  getType() const;

		/** Fast check for a given type, returns true if the selection is exactly the specified type name.
		  */
		bool 	isType(char *type)const;

		/** Sets the currently selected type.
		  * \sa getType,getTypePosibilities
		  * \exception std::exception On trying to select a type not in the list of posible values.
		  */
		void  setType(std::string type);


	}; // End of class def.

} // End of namespace

#endif
