/*---------------------------------------------------------------
	FILE: CHillClimbing.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CHillClimbing_H
#define  CHillClimbing_H

#include <MRPT/UTILS/CDebugOutputCapable.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class offers a hill climbing algorithm for a user-supplied functor.
	 * TODO: Explain how this works...
	 * \sa CSerializable
	 */
	class CHillClimbing : public CDebugOutputCapable
	{
	public:
		/** Executes the hill climbing.
		  * \param x0 The initial position for the algorithm (it also states the dimension of the variable "x").
		  * \param functor The user-suplied function to be optimized: functor(x,param)
		  * \param increments A vector with the elemental increments in each dimension of "x" (must be of the same dim)
		  * \param userParam This vector will be passed to the user functor: functor(x,param), where "x" is the variable to be optimized.
		  * \param maxIter The maximum number of iterations to run.
		  * \param findMinimum If set to false (default), the algorithm finds the maximum value. Otherwise it optimizes for the minimum value instead.
		  * \return The resulting maximum value "x" found by the hill climbing.
		  */
		vector_double  execute(
						vector_double				&x0,
						TFunctor_retDbl_inp2VecDbl	functor,
						vector_double				&increments,
						vector_double				&userParam,
						unsigned int				maxIter = 100,
						bool						findMinimum = false);

	}; // End of class def.

} // End of namespace

#endif
