/*---------------------------------------------------------------
	FILE: CFileStream.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CFILESTREAM_H
#define  CFILESTREAM_H

#include <MRPT/UTILS/CStream.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	enum TFileOpenModes {
		fomRead   = 0,
		fomWrite  = 1,
		fomAppend = 2 };

	/** This CStream derived class allow using a file as a stream.
	 *
	 * \sa CStream
	 */
	class CFileStream : public CStream
	{
	protected:
		 /** Method responsible for reading from the stream.
		 */
		size_t  Read(void *Buffer, unsigned int Count);

		/** Method responsible for writing to the stream.
		 *  Write attempts to write up to Count bytes to Buffer, and returns the number of bytes actually written.
		 */
		size_t  Write(const void *Buffer, unsigned int Count);

	private:
		/** The handle for the file
		 */
		FILE	*handle;

	public:
		 /** Constructor
		  *   In the constructor this parameters must be passed:
		  * \param fileName The file to be open in this stream
		  * \param fileOpenMode This values can be used: <br> fomRead: Open an existing file for read <br>fomWrite: Open a new or existing file for write, overwriting existing file if existing <br>fomAppend: Open an existing file for writing, opening at the end of file<br>
		  */
		CFileStream(const std::string &fileName, TFileOpenModes fileOpenMode );

		 /** Destructor
		 */
		 virtual ~CFileStream();

		 /** Says if file was open successfully or not.
		  */
		 bool  fileOpenCorrectly();

		/** Method for moving to a specified position in the streamed resource.
		 *   See documentation of CStream::Seek
		 */
		unsigned long  Seek(long Offset, CStream::TSeekOrigin Origin = sFromBeginning);

		/** Method for getting the total number of bytes writen to buffer.
		 */
		unsigned long  getTotalBytesCount();

		/** Method for getting the current cursor position, where 0 is the first byte and TotalBytesCount-1 the last one.
		 */
		unsigned long  getPosition();

		/** Clear totally the buffer, setting cursor position to start and freeing the buffer.
		 */
		void  Clear();

		/** Reads one string line from the file (until a new-line character)
		  * \return true if a line has been read, false on EOF or error.
		  */
        bool readLine( std::string &str );


	}; // End of class def.

} // End of namespace

#endif
