/*---------------------------------------------------------------
	FILE: CConfigFileMemory.h
	USE: See description below.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef  CConfigFileMemory_H
#define  CConfigFileMemory_H

#include <MRPT/UTILS/utils_defs.h>
#include <MRPT/UTILS/CConfigFileBase.h>
#include <MRPT/UTILS/CStringList.h>

/*---------------------------------------------------------------
	Class
  ---------------------------------------------------------------*/
namespace UTILS
{
	/** This class implements a config file-like interface over a memory-stored string list.
	  */
	class CConfigFileMemory : public CConfigFileBase
	{
	private:
		/** The IniFile object
		  */
		void                *m_ini;

	protected:
		/** A virtual method to write a generic string.
		  */
		void  writeString(const std::string &section,const std::string &name, const std::string &str);

		/** A virtual method to read a generic string.
		  */
		std::string  readString(
            const std::string &section,
            const std::string &name,
            const std::string &defaultStr,
            bool failIfNotFound = false) const;

	public:
		/** Constructor
		 */
		CConfigFileMemory( const UTILS::CStringList &stringList );

		/** Destructor
		 */
		virtual ~CConfigFileMemory( );

	}; // End of class def.

} // End of namespace

#endif
