/*---------------------------------------------------------------
	FILE: CImageGrabber_OpenCV.cpp
	USE: See doxygen doc.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CImageGrabber_OpenCV_H
#define CImageGrabber_OpenCV_H

#include <MRPT/config.h>

#include <MRPT/MRML/CObservationImage.h>

#include <MRPT/OTHERLIBS/OPENCV/highgui.h>

namespace MRVL
{

	/** A class for grabing images from a "OpenCV"-compatible camera, or from an AVI video file.
	  * NOTE:
	  *		- This class is only available when compiling MRPT with the flag "MRPT_HAS_OPENCV" defined.
	  *		- The libraries "highgui.lib" and "cxcore.lib" are automatically added to the list of libraries in the linking stage, or the debug versions if compiling with "_DEBUG".
	  */
	class CImageGrabber_OpenCV
	{
	protected:
		/** Set to false if we could not initialize the camera.
		  */
		bool	m_bInitialized;

		/** Internal use:
		  */
		CvCapture *m_capture;

	public:
		/** Constructor for cameras:
		 * \param cameraIndex Set the camera index, or -1 if it does not matter
		*/
		CImageGrabber_OpenCV( int cameraIndex = -1 );

		/** Constructor for AVI files:
		*/
		CImageGrabber_OpenCV( char *AVI_fileName );

		/** Destructor
		*/
		virtual ~CImageGrabber_OpenCV( );

		/** Grab an image from the opened camera.
		 * \param out_observation The object to be filled with sensed data.
		 *
		 * \return false on any error, true if all go fine.
		*/
		bool  getObservation( MRML::CObservationImage &out_observation);


	};	// End of class

} // End of NS


#endif
