/*---------------------------------------------------------------
	FILE: CHMapArc.h
	USE: See doxygen doc.

   Part of the MRPT Library
   ISA - Universidad de Malaga - http://www.isa.uma.es
  ---------------------------------------------------------------*/
#ifndef CHMapArc_H
#define CHMapArc_H

#include <MRPT/MRML/CSensorialFrame.h>
#include <MRPT/MRML/CHMapNode.h>
#include <MRPT/UTILS/CSerializable.h>

namespace MRML
{
	class CHierarchicalMap;

	/** A class for representing an arc between two nodes in a hierarchical map.
	 *
	 * \sa CHierarchicalMap,CHMapNode
	 */
	class CHMapArc : public CSerializable
	{
		friend class CHierarchicalMap;
		friend class CHMapNode;
		friend class CHierarchicalMapPartition;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE( CHMapArc )
	protected:
		/** The origin/target nodes for this arc.
		  */
		CHMapNode::THMapNodeID	nodeFrom,nodeTo;

		/** The hierarchical graph in which this object is into.
		  */
		CHierarchicalMap		*parent;

		 /** Event handler to be called just before a node is being destroyed: it should be called only for nodes involved in the arc, altought other cases must be handled without effects
		  *   When a node involved in the arc is delected, the corresponding pointer in the arc will be set to NULL and the arc is no longer a valid one.
		  */
		 void  onNodeDestruction(CHMapNode *node);

	public:
		/** Default constructor
		  */
		CHMapArc(	CHMapNode::THMapNodeID		from =0,
					CHMapNode::THMapNodeID		to   =0,
					CHierarchicalMap			*parent=NULL);

		/** Alternative constructor, for easiness.
		  */
		CHMapArc(	CHMapNode					*from,
					CHMapNode					*to,
					CHierarchicalMap			*parent);

		/** A class for storing a sequence of arcs (a path).
		  */
		class TArcList : public std::deque<MRML::CHMapArc*>
		{
		public:
			void  debugDump();
		};

        friend class TArcList;

		/** Destructor
		  */
		virtual ~CHMapArc();

		/** Return the starting node of the arc:
		  */
		CHMapNode::THMapNodeID	 getNodeFrom() { return nodeFrom; }

		/** Return the ending node of the arc:
		  */
		CHMapNode::THMapNodeID	 getNodeTo() { return nodeTo; }

		/** The type of the arc, the possibilities are:
				- "Membership"
				- "Navegability"
				- "RelativePose"
		  */
		CTypeSelector			arcType;

		/** The annotations of the arc, see the general description of the class for possible properties and values.
		  */
		CPropertiesValuesList	annotations;

	}; // End of class def.

} // End of namespace

#endif
