/* -*- C++ -*- $Id$ */

// ******  Code generated by the The ACE ORB (TAO) IDL Compiler *******
// TAO and the TAO IDL Compiler have been developed by the Center for
// Distributed Object Computing at Washington University, St. Louis.
//
// Information about TAO is available at:
//                 http://www.cs.wustl.edu/~schmidt/TAO.html

#ifndef _TAO_IDL_COSNAMINGC_H_
#define _TAO_IDL_COSNAMINGC_H_

#include "tao/corba.h"

#if defined (ACE_HAS_MINIMUM_IOSTREAMH_INCLUSION)
#include "ace/streams.h"
#endif /* ACE_HAS_MINIMUM_IOSTREAMH_INCLUSION */

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "orbsvcs_export.h"

#if defined (TAO_EXPORT_MACRO)
#undef TAO_EXPORT_MACRO
#endif
#define TAO_EXPORT_MACRO TAO_ORBSVCS_Export

#if defined (TAO_EXPORT_NESTED_CLASSES)
#  if defined (TAO_EXPORT_NESTED_MACRO)
#    undef TAO_EXPORT_NESTED_MACRO
#  endif /* defined (TAO_EXPORT_NESTED_MACRO) */
#  define TAO_EXPORT_NESTED_MACRO TAO_ORBSVCS_Export
#endif /* TAO_EXPORT_NESTED_CLASSES */

#if defined(_MSC_VER)
#if (_MSC_VER >= 1200)
#pragma warning(push)
#endif /* _MSC_VER >= 1200 */
#pragma warning(disable:4250)
#endif /* _MSC_VER */

TAO_NAMESPACE  CosNaming
{
  typedef char * Istring;
  typedef CORBA::String_var Istring_var;
  typedef CORBA::String_out Istring_out;
    TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_Istring;

  struct NameComponent;
  class NameComponent_var;
  
  struct TAO_ORBSVCS_Export NameComponent
  {

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef NameComponent_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

    TAO_String_Manager id;
    TAO_String_Manager kind;
  };

  class TAO_ORBSVCS_Export NameComponent_var
  {
  public:
    NameComponent_var (void); // default constructor
    NameComponent_var (NameComponent *);
    NameComponent_var (const NameComponent_var &); // copy constructor
    ~NameComponent_var (void); // destructor
    
    NameComponent_var &operator= (NameComponent *);
    NameComponent_var &operator= (const NameComponent_var &);
    NameComponent *operator-> (void);
    const NameComponent *operator-> (void) const;
    
    operator const NameComponent &() const;
    operator NameComponent &();
    operator NameComponent &() const;
    operator NameComponent *&(); // variable-size types only
    
    // in, inout, out, _retn 
    const NameComponent &in (void) const;
    NameComponent &inout (void);
    NameComponent *&out (void);
    NameComponent *_retn (void);
    NameComponent *ptr (void) const;

  private:
    NameComponent *ptr_;
  };

  class TAO_ORBSVCS_Export NameComponent_out
  {
  public:
    NameComponent_out (NameComponent *&);
    NameComponent_out (NameComponent_var &);
    NameComponent_out (const NameComponent_out &);
    NameComponent_out &operator= (const NameComponent_out &);
    NameComponent_out &operator= (NameComponent *);
    operator NameComponent *&();
    NameComponent *&ptr (void);
    NameComponent *operator-> (void);
    
  private:
    NameComponent *&ptr_;
    // assignment from T_var not allowed
    void operator= (const NameComponent_var &);
  };

  TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_NameComponent;


#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
    
#if !defined (__TAO_UNBOUNDED_SEQUENCE_COSNAMING_NAME_CH_)
#define __TAO_UNBOUNDED_SEQUENCE_COSNAMING_NAME_CH_

    class TAO_EXPORT_NESTED_MACRO _TAO_Unbounded_Sequence_CosNaming_Name : public TAO_Unbounded_Base_Sequence
    {
    public:
      // = Initialization and termination methods.
      
      _TAO_Unbounded_Sequence_CosNaming_Name (void); // Default constructor.
      _TAO_Unbounded_Sequence_CosNaming_Name (CORBA::ULong maximum); 
      _TAO_Unbounded_Sequence_CosNaming_Name (CORBA::ULong maximum,
        CORBA::ULong length,
        NameComponent *data,
        CORBA::Boolean release = 0);
      _TAO_Unbounded_Sequence_CosNaming_Name (const _TAO_Unbounded_Sequence_CosNaming_Name &rhs);
      _TAO_Unbounded_Sequence_CosNaming_Name &operator= (const _TAO_Unbounded_Sequence_CosNaming_Name &rhs);
      virtual ~_TAO_Unbounded_Sequence_CosNaming_Name (void); // Dtor.
      // = Accessors.
      NameComponent &operator[] (CORBA::ULong i);
      const NameComponent &operator[] (CORBA::ULong i) const;
      // = Static operations.
      static NameComponent *allocbuf (CORBA::ULong size);
      static void freebuf (NameComponent *buffer);
      virtual void _allocate_buffer (CORBA::ULong length);
      virtual void _deallocate_buffer (void);
      // Implement the TAO_Base_Sequence methods (see Sequence.h)
      
      NameComponent *get_buffer (CORBA::Boolean orphan = 0);
      const NameComponent *get_buffer (void) const;
      void replace (CORBA::ULong max,
        CORBA::ULong length,
        NameComponent *data,
        CORBA::Boolean release);
    };

#endif /* end #if !defined */


#endif /* !TAO_USE_SEQUENCE_TEMPLATES */ 
  
#if !defined (_COSNAMING_NAME_CH_)
#define _COSNAMING_NAME_CH_

  class Name;
  class Name_var;
  typedef Name* Name_ptr;
  
  // *************************************************************
  // Name
  // *************************************************************
  
  class TAO_ORBSVCS_Export Name : public 
#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
    _TAO_Unbounded_Sequence_CosNaming_Name
#else /* TAO_USE_SEQUENCE_TEMPLATES */
    TAO_Unbounded_Sequence<NameComponent>
#endif /* !TAO_USE_SEQUENCE_TEMPLATES */ 
  {
  public:
    Name (void); // default ctor
    Name (CORBA::ULong max); // uses max size
    Name (
      CORBA::ULong max, 
      CORBA::ULong length, 
      NameComponent *buffer, 
      CORBA::Boolean release=0
    );
    Name (const Name &); // copy ctor
    ~Name (void); // dtor

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef Name_ptr _ptr_type;
    typedef Name_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  };

#endif /* end #if !defined */


#if !defined (_COSNAMING_NAME___VAR_CH_)
#define _COSNAMING_NAME___VAR_CH_

// *************************************************************
// class CosNaming::Name_var
// *************************************************************

class TAO_ORBSVCS_Export Name_var
{
public:
  Name_var (void); // default constructor
  Name_var (Name *);
  Name_var (const Name_var &); // copy constructor
  ~Name_var (void); // destructor
  
  Name_var &operator= (Name *);
  Name_var &operator= (const Name_var &);
  Name *operator-> (void);
  const Name *operator-> (void) const;
  
  operator const Name &() const;
  operator Name &();
  operator Name &() const;
  operator Name *&(); // variable-size base types only
  
  NameComponent &operator[] (CORBA::ULong index);
  // in, inout, out, _retn 
  const Name &in (void) const;
  Name &inout (void);
  Name *&out (void);
  Name *_retn (void);
  Name *ptr (void) const;

private:
  Name *ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAME___OUT_CH_)
#define _COSNAMING_NAME___OUT_CH_

class TAO_ORBSVCS_Export Name_out
{
public:
  Name_out (Name *&);
  Name_out (Name_var &);
  Name_out (const Name_out &);
  Name_out &operator= (const Name_out &);
  Name_out &operator= (Name *);
  operator Name *&();
  Name *&ptr (void);
  Name *operator-> (void);
  NameComponent &operator[] (CORBA::ULong index);
  
private:
  Name *&ptr_;
  // assignment from T_var not allowed
  void operator= (const Name_var &);
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_Name;

enum BindingType
{
    nobject,
    ncontext,
    BindingType_TAO_ENUM_32BIT_ENFORCER = 0x7FFFFFFF
};
typedef BindingType &BindingType_out;
TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_BindingType;

struct Binding;
class Binding_var;

struct TAO_ORBSVCS_Export Binding
{

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef Binding_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  ACE_NESTED_CLASS (CosNaming, Name) binding_name;
  ACE_NESTED_CLASS (CosNaming, BindingType) binding_type;
};

class TAO_ORBSVCS_Export Binding_var
{
public:
  Binding_var (void); // default constructor
  Binding_var (Binding *);
  Binding_var (const Binding_var &); // copy constructor
  ~Binding_var (void); // destructor
  
  Binding_var &operator= (Binding *);
  Binding_var &operator= (const Binding_var &);
  Binding *operator-> (void);
  const Binding *operator-> (void) const;
  
  operator const Binding &() const;
  operator Binding &();
  operator Binding &() const;
  operator Binding *&(); // variable-size types only
  
  // in, inout, out, _retn 
  const Binding &in (void) const;
  Binding &inout (void);
  Binding *&out (void);
  Binding *_retn (void);
  Binding *ptr (void) const;

private:
  Binding *ptr_;
};

class TAO_ORBSVCS_Export Binding_out
{
public:
  Binding_out (Binding *&);
  Binding_out (Binding_var &);
  Binding_out (const Binding_out &);
  Binding_out &operator= (const Binding_out &);
  Binding_out &operator= (Binding *);
  operator Binding *&();
  Binding *&ptr (void);
  Binding *operator-> (void);
  
private:
  Binding *&ptr_;
  // assignment from T_var not allowed
  void operator= (const Binding_var &);
};

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_Binding;


#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
  
#if !defined (__TAO_UNBOUNDED_SEQUENCE_COSNAMING_BINDINGLIST_CH_)
#define __TAO_UNBOUNDED_SEQUENCE_COSNAMING_BINDINGLIST_CH_

  class TAO_EXPORT_NESTED_MACRO _TAO_Unbounded_Sequence_CosNaming_BindingList : public TAO_Unbounded_Base_Sequence
  {
  public:
    // = Initialization and termination methods.
    
    _TAO_Unbounded_Sequence_CosNaming_BindingList (void); // Default constructor.
    _TAO_Unbounded_Sequence_CosNaming_BindingList (CORBA::ULong maximum); 
    _TAO_Unbounded_Sequence_CosNaming_BindingList (CORBA::ULong maximum,
      CORBA::ULong length,
      Binding *data,
      CORBA::Boolean release = 0);
    _TAO_Unbounded_Sequence_CosNaming_BindingList (const _TAO_Unbounded_Sequence_CosNaming_BindingList &rhs);
    _TAO_Unbounded_Sequence_CosNaming_BindingList &operator= (const _TAO_Unbounded_Sequence_CosNaming_BindingList &rhs);
    virtual ~_TAO_Unbounded_Sequence_CosNaming_BindingList (void); // Dtor.
    // = Accessors.
    Binding &operator[] (CORBA::ULong i);
    const Binding &operator[] (CORBA::ULong i) const;
    // = Static operations.
    static Binding *allocbuf (CORBA::ULong size);
    static void freebuf (Binding *buffer);
    virtual void _allocate_buffer (CORBA::ULong length);
    virtual void _deallocate_buffer (void);
    // Implement the TAO_Base_Sequence methods (see Sequence.h)
    
    Binding *get_buffer (CORBA::Boolean orphan = 0);
    const Binding *get_buffer (void) const;
    void replace (CORBA::ULong max,
      CORBA::ULong length,
      Binding *data,
      CORBA::Boolean release);
  };

#endif /* end #if !defined */


#endif /* !TAO_USE_SEQUENCE_TEMPLATES */ 

#if !defined (_COSNAMING_BINDINGLIST_CH_)
#define _COSNAMING_BINDINGLIST_CH_

class BindingList;
class BindingList_var;
typedef BindingList* BindingList_ptr;

// *************************************************************
// BindingList
// *************************************************************

class TAO_ORBSVCS_Export BindingList : public 
#if !defined (TAO_USE_SEQUENCE_TEMPLATES)
  _TAO_Unbounded_Sequence_CosNaming_BindingList
#else /* TAO_USE_SEQUENCE_TEMPLATES */
  TAO_Unbounded_Sequence<Binding>
#endif /* !TAO_USE_SEQUENCE_TEMPLATES */ 
{
public:
  BindingList (void); // default ctor
  BindingList (CORBA::ULong max); // uses max size
  BindingList (
    CORBA::ULong max, 
    CORBA::ULong length, 
    Binding *buffer, 
    CORBA::Boolean release=0
  );
  BindingList (const BindingList &); // copy ctor
  ~BindingList (void); // dtor

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef BindingList_ptr _ptr_type;
  typedef BindingList_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

};

#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGLIST___VAR_CH_)
#define _COSNAMING_BINDINGLIST___VAR_CH_

// *************************************************************
// class CosNaming::BindingList_var
// *************************************************************

class TAO_ORBSVCS_Export BindingList_var
{
public:
  BindingList_var (void); // default constructor
  BindingList_var (BindingList *);
  BindingList_var (const BindingList_var &); // copy constructor
  ~BindingList_var (void); // destructor
  
  BindingList_var &operator= (BindingList *);
  BindingList_var &operator= (const BindingList_var &);
  BindingList *operator-> (void);
  const BindingList *operator-> (void) const;
  
  operator const BindingList &() const;
  operator BindingList &();
  operator BindingList &() const;
  operator BindingList *&(); // variable-size base types only
  
  Binding &operator[] (CORBA::ULong index);
  // in, inout, out, _retn 
  const BindingList &in (void) const;
  BindingList &inout (void);
  BindingList *&out (void);
  BindingList *_retn (void);
  BindingList *ptr (void) const;

private:
  BindingList *ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGLIST___OUT_CH_)
#define _COSNAMING_BINDINGLIST___OUT_CH_

class TAO_ORBSVCS_Export BindingList_out
{
public:
  BindingList_out (BindingList *&);
  BindingList_out (BindingList_var &);
  BindingList_out (const BindingList_out &);
  BindingList_out &operator= (const BindingList_out &);
  BindingList_out &operator= (BindingList *);
  operator BindingList *&();
  BindingList *&ptr (void);
  BindingList *operator-> (void);
  Binding &operator[] (CORBA::ULong index);
  
private:
  BindingList *&ptr_;
  // assignment from T_var not allowed
  void operator= (const BindingList_var &);
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_BindingList;

class BindingIterator;

#if !defined (_COSNAMING_BINDINGITERATOR___PTR_CH_)
#define _COSNAMING_BINDINGITERATOR___PTR_CH_

typedef BindingIterator *BindingIterator_ptr;

#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGITERATOR___VAR_CH_)
#define _COSNAMING_BINDINGITERATOR___VAR_CH_

class TAO_ORBSVCS_Export BindingIterator_var
{
public:
  BindingIterator_var (void); // default constructor
  BindingIterator_var (BindingIterator_ptr);
  BindingIterator_var (const BindingIterator_var &); // copy constructor
  ~BindingIterator_var (void); // destructor
  
  BindingIterator_var &operator= (BindingIterator_ptr);
  BindingIterator_var &operator= (const BindingIterator_var &);
  BindingIterator_ptr operator-> (void) const;
  
  operator const BindingIterator_ptr &() const;
  operator BindingIterator_ptr &();
  // in, inout, out, _retn 
  BindingIterator_ptr in (void) const;
  BindingIterator_ptr &inout (void);
  BindingIterator_ptr &out (void);
  BindingIterator_ptr _retn (void);
  BindingIterator_ptr ptr (void) const;

private:
  BindingIterator_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGITERATOR___OUT_CH_)
#define _COSNAMING_BINDINGITERATOR___OUT_CH_

class TAO_ORBSVCS_Export BindingIterator_out
{
public:
  BindingIterator_out (BindingIterator_ptr &);
  BindingIterator_out (BindingIterator_var &);
  BindingIterator_out (const BindingIterator_out &);
  BindingIterator_out &operator= (const BindingIterator_out &);
  BindingIterator_out &operator= (const BindingIterator_var &);
  BindingIterator_out &operator= (BindingIterator_ptr);
  operator BindingIterator_ptr &();
  BindingIterator_ptr &ptr (void);
  BindingIterator_ptr operator-> (void);
  
private:
  BindingIterator_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT___PTR_CH_

class NamingContext;
typedef NamingContext *NamingContext_ptr;

#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT___VAR_CH_)
#define _COSNAMING_NAMINGCONTEXT___VAR_CH_

class TAO_ORBSVCS_Export NamingContext_var
{
public:
  NamingContext_var (void); // default constructor
  NamingContext_var (NamingContext_ptr);
  NamingContext_var (const NamingContext_var &); // copy constructor
  ~NamingContext_var (void); // destructor
  
  NamingContext_var &operator= (NamingContext_ptr);
  NamingContext_var &operator= (const NamingContext_var &);
  NamingContext_ptr operator-> (void) const;
  
  operator const NamingContext_ptr &() const;
  operator NamingContext_ptr &();
  // in, inout, out, _retn 
  NamingContext_ptr in (void) const;
  NamingContext_ptr &inout (void);
  NamingContext_ptr &out (void);
  NamingContext_ptr _retn (void);
  NamingContext_ptr ptr (void) const;

private:
  NamingContext_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT___OUT_CH_)
#define _COSNAMING_NAMINGCONTEXT___OUT_CH_

class TAO_ORBSVCS_Export NamingContext_out
{
public:
  NamingContext_out (NamingContext_ptr &);
  NamingContext_out (NamingContext_var &);
  NamingContext_out (const NamingContext_out &);
  NamingContext_out &operator= (const NamingContext_out &);
  NamingContext_out &operator= (const NamingContext_var &);
  NamingContext_out &operator= (NamingContext_ptr);
  operator NamingContext_ptr &();
  NamingContext_ptr &ptr (void);
  NamingContext_ptr operator-> (void);
  
private:
  NamingContext_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_CH_)
#define _COSNAMING_NAMINGCONTEXT_CH_

class TAO_ORBSVCS_Export NamingContext : public virtual ACE_CORBA_1 (Object)
{
public:
#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef NamingContext_ptr _ptr_type;
  typedef NamingContext_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  // the static operations
  static NamingContext_ptr _duplicate (NamingContext_ptr obj);
  static NamingContext_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  static NamingContext_ptr _unchecked_narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  static NamingContext_ptr _nil (void)
    {
      return (NamingContext_ptr)0;
    }

  enum NotFoundReason
  {
        missing_node,
        not_context,
        not_object,
        NotFoundReason_TAO_ENUM_32BIT_ENFORCER = 0x7FFFFFFF
  };
  typedef NotFoundReason &NotFoundReason_out;
  static CORBA::TypeCode_ptr _tc_NotFoundReason;


#if !defined (_COSNAMING_NAMINGCONTEXT_NOTFOUND___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT_NOTFOUND___PTR_CH_

  class NotFound;
  typedef NotFound *NotFound_ptr;
  
#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_NOTFOUND_CH_)
#define _COSNAMING_NAMINGCONTEXT_NOTFOUND_CH_

  class TAO_ORBSVCS_Export NotFound : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef NotFound_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

    ACE_NESTED_CLASS (CosNaming::NamingContext, NotFoundReason) why;
    ACE_NESTED_CLASS (CosNaming, Name) rest_of_name;

    NotFound (void); // default ctor
    NotFound (const NotFound &); // copy ctor
    ~NotFound (void); // dtor
    NotFound &operator= (const NotFound &);


    virtual void _raise (void);

    virtual void _tao_encode (
        TAO_OutputCDR &,
        CORBA::Environment &) const;
    virtual void _tao_decode (
        TAO_InputCDR &,
        CORBA::Environment &);

    static NotFound *_narrow (CORBA::Exception *);

    NotFound (
      ACE_NESTED_CLASS (CosNaming::NamingContext, NotFoundReason) _tao_why,
      const ACE_NESTED_CLASS (CosNaming, Name) & _tao_rest_of_name
    );

    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception CosNaming::NamingContext::NotFound

    static CORBA::TypeCode_ptr _tc_NotFound;


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_CANNOTPROCEED___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT_CANNOTPROCEED___PTR_CH_

  class CannotProceed;
  typedef CannotProceed *CannotProceed_ptr;
  
#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_CANNOTPROCEED_CH_)
#define _COSNAMING_NAMINGCONTEXT_CANNOTPROCEED_CH_

  class TAO_ORBSVCS_Export CannotProceed : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef CannotProceed_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

    TAO_Object_Field_T<ACE_NESTED_CLASS (CosNaming, NamingContext), ACE_NESTED_CLASS (CosNaming, NamingContext_var)> cxt;
    ACE_NESTED_CLASS (CosNaming, Name) rest_of_name;

    CannotProceed (void); // default ctor
    CannotProceed (const CannotProceed &); // copy ctor
    ~CannotProceed (void); // dtor
    CannotProceed &operator= (const CannotProceed &);


    virtual void _raise (void);

    virtual void _tao_encode (
        TAO_OutputCDR &,
        CORBA::Environment &) const;
    virtual void _tao_decode (
        TAO_InputCDR &,
        CORBA::Environment &);

    static CannotProceed *_narrow (CORBA::Exception *);

    CannotProceed (
      const ACE_NESTED_CLASS (CosNaming, NamingContext_ptr ) _tao_cxt,
      const ACE_NESTED_CLASS (CosNaming, Name) & _tao_rest_of_name
    );

    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception CosNaming::NamingContext::CannotProceed

    static CORBA::TypeCode_ptr _tc_CannotProceed;


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_INVALIDNAME___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT_INVALIDNAME___PTR_CH_

  class InvalidName;
  typedef InvalidName *InvalidName_ptr;
  
#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_INVALIDNAME_CH_)
#define _COSNAMING_NAMINGCONTEXT_INVALIDNAME_CH_

  class TAO_ORBSVCS_Export InvalidName : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef InvalidName_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */


    InvalidName (void); // default ctor
    InvalidName (const InvalidName &); // copy ctor
    ~InvalidName (void); // dtor
    InvalidName &operator= (const InvalidName &);


    virtual void _raise (void);

    virtual void _tao_encode (
        TAO_OutputCDR &,
        CORBA::Environment &) const;
    virtual void _tao_decode (
        TAO_InputCDR &,
        CORBA::Environment &);

    static InvalidName *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception CosNaming::NamingContext::InvalidName

    static CORBA::TypeCode_ptr _tc_InvalidName;


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_ALREADYBOUND___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT_ALREADYBOUND___PTR_CH_

  class AlreadyBound;
  typedef AlreadyBound *AlreadyBound_ptr;
  
#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_ALREADYBOUND_CH_)
#define _COSNAMING_NAMINGCONTEXT_ALREADYBOUND_CH_

  class TAO_ORBSVCS_Export AlreadyBound : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef AlreadyBound_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */


    AlreadyBound (void); // default ctor
    AlreadyBound (const AlreadyBound &); // copy ctor
    ~AlreadyBound (void); // dtor
    AlreadyBound &operator= (const AlreadyBound &);


    virtual void _raise (void);

    virtual void _tao_encode (
        TAO_OutputCDR &,
        CORBA::Environment &) const;
    virtual void _tao_decode (
        TAO_InputCDR &,
        CORBA::Environment &);

    static AlreadyBound *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception CosNaming::NamingContext::AlreadyBound

    static CORBA::TypeCode_ptr _tc_AlreadyBound;


#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_NOTEMPTY___PTR_CH_)
#define _COSNAMING_NAMINGCONTEXT_NOTEMPTY___PTR_CH_

  class NotEmpty;
  typedef NotEmpty *NotEmpty_ptr;
  
#endif /* end #if !defined */


#if !defined (_COSNAMING_NAMINGCONTEXT_NOTEMPTY_CH_)
#define _COSNAMING_NAMINGCONTEXT_NOTEMPTY_CH_

  class TAO_ORBSVCS_Export NotEmpty : public CORBA::UserException
  {
  public:

#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
    typedef NotEmpty_ptr _ptr_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */


    NotEmpty (void); // default ctor
    NotEmpty (const NotEmpty &); // copy ctor
    ~NotEmpty (void); // dtor
    NotEmpty &operator= (const NotEmpty &);


    virtual void _raise (void);

    virtual void _tao_encode (
        TAO_OutputCDR &,
        CORBA::Environment &) const;
    virtual void _tao_decode (
        TAO_InputCDR &,
        CORBA::Environment &);

    static NotEmpty *_narrow (CORBA::Exception *);


    // = TAO extension
    static CORBA::Exception *_alloc (void);

  }; // exception CosNaming::NamingContext::NotEmpty

    static CORBA::TypeCode_ptr _tc_NotEmpty;


#endif /* end #if !defined */

  virtual void bind (
      const CosNaming::Name & n,
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName,
      CosNaming::NamingContext::AlreadyBound
    ));

  virtual void rebind (
      const CosNaming::Name & n,
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void bind_context (
      const CosNaming::Name & n,
      CosNaming::NamingContext_ptr nc,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName,
      CosNaming::NamingContext::AlreadyBound
    ));

  virtual void rebind_context (
      const CosNaming::Name & n,
      CosNaming::NamingContext_ptr nc,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual CORBA::Object_ptr resolve (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void unbind (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual CosNaming::NamingContext_ptr new_context (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CosNaming::NamingContext_ptr bind_new_context (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::AlreadyBound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotEmpty
    ));

  virtual void list (
      CORBA::ULong how_many,
      CosNaming::BindingList_out bl,
      CosNaming::BindingIterator_out bi,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id, 
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

protected:
  NamingContext (void);
  NamingContext (TAO_Stub *objref, 
      TAO_ServantBase *_tao_servant = 0, 
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~NamingContext (void);
private:
  NamingContext (const NamingContext &);
  void operator= (const NamingContext &);
};

class TAO_CosNaming_NamingContext_Default_Proxy_Factory
{
public:
  
  TAO_CosNaming_NamingContext_Default_Proxy_Factory (int register_proxy_factory = 1);
  
  virtual ~TAO_CosNaming_NamingContext_Default_Proxy_Factory (void);
  
  virtual NamingContext_ptr create_proxy (
      NamingContext_ptr proxy,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
};

class TAO_CosNaming_NamingContext_Proxy_Factory_Adapter
{
public:
  
  friend class ACE_Singleton<TAO_CosNaming_NamingContext_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX>;
  
  int register_proxy_factory (
      TAO_CosNaming_NamingContext_Default_Proxy_Factory *df,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  
  int unregister_proxy_factory (
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  
  NamingContext_ptr create_proxy (
      NamingContext_ptr proxy,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );

protected:
  TAO_CosNaming_NamingContext_Proxy_Factory_Adapter (void);
  ~TAO_CosNaming_NamingContext_Proxy_Factory_Adapter (void);
  TAO_CosNaming_NamingContext_Proxy_Factory_Adapter &operator= (
      const TAO_CosNaming_NamingContext_Proxy_Factory_Adapter &
    );
  TAO_CosNaming_NamingContext_Default_Proxy_Factory *proxy_factory_;
  int delete_proxy_factory_;
  ACE_SYNCH_RECURSIVE_MUTEX lock_;
  };

  typedef ACE_Singleton<TAO_CosNaming_NamingContext_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX> TAO_CosNaming_NamingContext_PROXY_FACTORY_ADAPTER;
  class TAO_CosNaming_NamingContext_Smart_Proxy_Base : public virtual ACE_NESTED_CLASS (CosNaming, NamingContext)
  {
  public:
    TAO_CosNaming_NamingContext_Smart_Proxy_Base (::CosNaming::NamingContext_ptr proxy);
    ~TAO_CosNaming_NamingContext_Smart_Proxy_Base (void);
      virtual void bind (
      const CosNaming::Name & n,
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName,
      CosNaming::NamingContext::AlreadyBound
    ));

  virtual void rebind (
      const CosNaming::Name & n,
      CORBA::Object_ptr obj,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void bind_context (
      const CosNaming::Name & n,
      CosNaming::NamingContext_ptr nc,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName,
      CosNaming::NamingContext::AlreadyBound
    ));

  virtual void rebind_context (
      const CosNaming::Name & n,
      CosNaming::NamingContext_ptr nc,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual CORBA::Object_ptr resolve (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void unbind (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual CosNaming::NamingContext_ptr new_context (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CosNaming::NamingContext_ptr bind_new_context (
      const CosNaming::Name & n,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotFound,
      CosNaming::NamingContext::AlreadyBound,
      CosNaming::NamingContext::CannotProceed,
      CosNaming::NamingContext::InvalidName
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException,
      CosNaming::NamingContext::NotEmpty
    ));

  virtual void list (
      CORBA::ULong how_many,
      CosNaming::BindingList_out bl,
      CosNaming::BindingIterator_out bi,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

private:
  ::CosNaming::NamingContext_var base_proxy_;
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_NamingContext;


#if !defined (_COSNAMING_BINDINGITERATOR___PTR_CH_)
#define _COSNAMING_BINDINGITERATOR___PTR_CH_

class BindingIterator;
typedef BindingIterator *BindingIterator_ptr;

#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGITERATOR___VAR_CH_)
#define _COSNAMING_BINDINGITERATOR___VAR_CH_

class TAO_ORBSVCS_Export BindingIterator_var
{
public:
  BindingIterator_var (void); // default constructor
  BindingIterator_var (BindingIterator_ptr);
  BindingIterator_var (const BindingIterator_var &); // copy constructor
  ~BindingIterator_var (void); // destructor
  
  BindingIterator_var &operator= (BindingIterator_ptr);
  BindingIterator_var &operator= (const BindingIterator_var &);
  BindingIterator_ptr operator-> (void) const;
  
  operator const BindingIterator_ptr &() const;
  operator BindingIterator_ptr &();
  // in, inout, out, _retn 
  BindingIterator_ptr in (void) const;
  BindingIterator_ptr &inout (void);
  BindingIterator_ptr &out (void);
  BindingIterator_ptr _retn (void);
  BindingIterator_ptr ptr (void) const;

private:
  BindingIterator_ptr ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGITERATOR___OUT_CH_)
#define _COSNAMING_BINDINGITERATOR___OUT_CH_

class TAO_ORBSVCS_Export BindingIterator_out
{
public:
  BindingIterator_out (BindingIterator_ptr &);
  BindingIterator_out (BindingIterator_var &);
  BindingIterator_out (const BindingIterator_out &);
  BindingIterator_out &operator= (const BindingIterator_out &);
  BindingIterator_out &operator= (const BindingIterator_var &);
  BindingIterator_out &operator= (BindingIterator_ptr);
  operator BindingIterator_ptr &();
  BindingIterator_ptr &ptr (void);
  BindingIterator_ptr operator-> (void);
  
private:
  BindingIterator_ptr &ptr_;
};


#endif /* end #if !defined */


#if !defined (_COSNAMING_BINDINGITERATOR_CH_)
#define _COSNAMING_BINDINGITERATOR_CH_

class TAO_ORBSVCS_Export BindingIterator : public virtual ACE_CORBA_1 (Object)
{
public:
#if !defined(__GNUC__) || !defined (ACE_HAS_GNUG_PRE_2_8)
  typedef BindingIterator_ptr _ptr_type;
  typedef BindingIterator_var _var_type;
#endif /* ! __GNUC__ || g++ >= 2.8 */

  // the static operations
  static BindingIterator_ptr _duplicate (BindingIterator_ptr obj);
  static BindingIterator_ptr _narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  static BindingIterator_ptr _unchecked_narrow (
      CORBA::Object_ptr obj,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  static BindingIterator_ptr _nil (void)
    {
      return (BindingIterator_ptr)0;
    }

  virtual CORBA::Boolean next_one (
      CosNaming::Binding_out b,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean next_n (
      CORBA::ULong how_many,
      CosNaming::BindingList_out bl,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean _is_a (
      const CORBA::Char *type_id, 
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  virtual const char* _interface_repository_id (void) const;

protected:
  BindingIterator (void);
  BindingIterator (TAO_Stub *objref, 
      TAO_ServantBase *_tao_servant = 0, 
      CORBA::Boolean _tao_collocated = 0
    );
  virtual ~BindingIterator (void);
private:
  BindingIterator (const BindingIterator &);
  void operator= (const BindingIterator &);
};

class TAO_CosNaming_BindingIterator_Default_Proxy_Factory
{
public:
  
  TAO_CosNaming_BindingIterator_Default_Proxy_Factory (int register_proxy_factory = 1);
  
  virtual ~TAO_CosNaming_BindingIterator_Default_Proxy_Factory (void);
  
  virtual BindingIterator_ptr create_proxy (
      BindingIterator_ptr proxy,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
};

class TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter
{
public:
  
  friend class ACE_Singleton<TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX>;
  
  int register_proxy_factory (
      TAO_CosNaming_BindingIterator_Default_Proxy_Factory *df,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  
  int unregister_proxy_factory (
      CORBA::Environment &env = 
        TAO_default_environment ()
    );
  
  BindingIterator_ptr create_proxy (
      BindingIterator_ptr proxy,
      CORBA::Environment &env = 
        TAO_default_environment ()
    );

protected:
  TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter (void);
  ~TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter (void);
  TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter &operator= (
      const TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter &
    );
  TAO_CosNaming_BindingIterator_Default_Proxy_Factory *proxy_factory_;
  int delete_proxy_factory_;
  ACE_SYNCH_RECURSIVE_MUTEX lock_;
  };

  typedef ACE_Singleton<TAO_CosNaming_BindingIterator_Proxy_Factory_Adapter, ACE_SYNCH_RECURSIVE_MUTEX> TAO_CosNaming_BindingIterator_PROXY_FACTORY_ADAPTER;
  class TAO_CosNaming_BindingIterator_Smart_Proxy_Base : public virtual ACE_NESTED_CLASS (CosNaming, BindingIterator)
  {
  public:
    TAO_CosNaming_BindingIterator_Smart_Proxy_Base (::CosNaming::BindingIterator_ptr proxy);
    ~TAO_CosNaming_BindingIterator_Smart_Proxy_Base (void);
      virtual CORBA::Boolean next_one (
      CosNaming::Binding_out b,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual CORBA::Boolean next_n (
      CORBA::ULong how_many,
      CosNaming::BindingList_out bl,
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

  virtual void destroy (
      CORBA::Environment &ACE_TRY_ENV = 
        TAO_default_environment ()
    )
    ACE_THROW_SPEC ((
      CORBA::SystemException
    ));

private:
  ::CosNaming::BindingIterator_var base_proxy_;
};


#endif /* end #if !defined */

TAO_NAMESPACE_STORAGE_CLASS CORBA::TypeCode_ptr _tc_BindingIterator;


}
TAO_NAMESPACE_CLOSE // module CosNaming

TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NameComponent &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NameComponent*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NameComponent *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NameComponent *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::Name &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::Name*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::Name *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::Name *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::BindingType);
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::BindingType &);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::Binding &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::Binding*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::Binding *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::Binding *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::BindingList &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::BindingList*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::BindingList *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::BindingList *&);
extern TAO_ORBSVCS_Export CosNaming::NamingContext_ptr (*_TAO_collocation_CosNaming_NamingContext_Stub_Factory_function_pointer) (
    CORBA::Object_ptr obj
  );
// Any operators for interface CosNaming::NamingContext
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext_ptr);
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::NotFoundReason);
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::NotFoundReason &);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NamingContext::NotFound &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::NotFound*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::NotFound *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NamingContext::NotFound *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NamingContext::CannotProceed &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::CannotProceed*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::CannotProceed *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NamingContext::CannotProceed *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NamingContext::InvalidName &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::InvalidName*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::InvalidName *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NamingContext::InvalidName *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NamingContext::AlreadyBound &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::AlreadyBound*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::AlreadyBound *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NamingContext::AlreadyBound *&);
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, const CosNaming::NamingContext::NotEmpty &); // copying version
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::NamingContext::NotEmpty*); // noncopying version
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::NamingContext::NotEmpty *&); // deprecated
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, const CosNaming::NamingContext::NotEmpty *&);
extern TAO_ORBSVCS_Export CosNaming::BindingIterator_ptr (*_TAO_collocation_CosNaming_BindingIterator_Stub_Factory_function_pointer) (
    CORBA::Object_ptr obj
  );
// Any operators for interface CosNaming::BindingIterator
TAO_ORBSVCS_Export void operator<<= (CORBA::Any &, CosNaming::BindingIterator_ptr);
TAO_ORBSVCS_Export CORBA::Boolean operator>>= (const CORBA::Any &, CosNaming::BindingIterator *&);

#ifndef __ACE_INLINE__

TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NameComponent &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NameComponent &);

#if !defined _TAO_CDR_OP_CosNaming_Name_H_
#define _TAO_CDR_OP_CosNaming_Name_H_

TAO_ORBSVCS_Export CORBA::Boolean operator<< (
    TAO_OutputCDR &,
    const CosNaming::Name &
  );
TAO_ORBSVCS_Export CORBA::Boolean operator>> (
    TAO_InputCDR &,
    CosNaming::Name &
  );

#endif /* _TAO_CDR_OP_CosNaming_Name_H_ */

TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::BindingType &); // 
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::BindingType &);
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::Binding &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::Binding &);

#if !defined _TAO_CDR_OP_CosNaming_BindingList_H_
#define _TAO_CDR_OP_CosNaming_BindingList_H_

TAO_ORBSVCS_Export CORBA::Boolean operator<< (
    TAO_OutputCDR &,
    const CosNaming::BindingList &
  );
TAO_ORBSVCS_Export CORBA::Boolean operator>> (
    TAO_InputCDR &,
    CosNaming::BindingList &
  );

#endif /* _TAO_CDR_OP_CosNaming_BindingList_H_ */

TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext_ptr );
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext_ptr &);
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::NotFoundReason &); // 
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::NotFoundReason &);
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::NotFound &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::NotFound &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_ORBSVCS_Export ostream& operator<< (ostream &, const CosNaming::NamingContext::NotFound &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::CannotProceed &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::CannotProceed &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_ORBSVCS_Export ostream& operator<< (ostream &, const CosNaming::NamingContext::CannotProceed &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::InvalidName &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::InvalidName &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_ORBSVCS_Export ostream& operator<< (ostream &, const CosNaming::NamingContext::InvalidName &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::AlreadyBound &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::AlreadyBound &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_ORBSVCS_Export ostream& operator<< (ostream &, const CosNaming::NamingContext::AlreadyBound &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::NamingContext::NotEmpty &);
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::NamingContext::NotEmpty &);

# if !defined (ACE_LACKS_IOSTREAM_TOTALLY)

TAO_ORBSVCS_Export ostream& operator<< (ostream &, const CosNaming::NamingContext::NotEmpty &);

# endif /* ACE_LACKS_IOSTREAM_TOTALLY */
TAO_ORBSVCS_Export CORBA::Boolean operator<< (TAO_OutputCDR &, const CosNaming::BindingIterator_ptr );
TAO_ORBSVCS_Export CORBA::Boolean operator>> (TAO_InputCDR &, CosNaming::BindingIterator_ptr &);

#endif /* __ACE_INLINE__ */


#if defined (__ACE_INLINE__)
#include "CosNamingC.i"
#endif /* defined INLINE */

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
#pragma warning(pop)
#endif /* _MSC_VER */

#endif /* ifndef */
